% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/monitorPlot_hourlyBarplot.R
\name{monitorPlot_hourlyBarplot}
\alias{monitorPlot_hourlyBarplot}
\title{Create Hourly Barplot}
\usage{
monitorPlot_hourlyBarplot(ws_monitor, monitorID = NULL, tlim = NULL,
  localTime = TRUE, style = "AQI", shadedNight = TRUE, gridPos = "",
  gridCol = "black", gridLwd = 0.5, gridLty = "solid",
  labels_x_nudge = 0, labels_y_nudge = 0, dayCol = "black", dayLwd = 2,
  dayLty = "solid", hourCol = "black", hourLwd = 1, hourLty = "solid",
  hourInterval = 6, ...)
}
\arguments{
\item{ws_monitor}{\emph{ws_monitor} object}

\item{monitorID}{monitor ID for a specific monitor in \code{ws_monitor} (optional
if \code{ws_monitor} only has one monitor)}

\item{tlim}{optional vector with start and end times (integer or character representing YYYYMMDD[HH])}

\item{localTime}{logical specifying whether \code{tlim} is in local time or UTC}

\item{style}{named style specification ('AirFire')}

\item{shadedNight}{add nighttime shading}

\item{gridPos}{position of grid lines either 'over', 'under' ('' for no grid lines)}

\item{gridCol}{grid color}

\item{gridLwd}{grid line width}

\item{gridLty}{grid line type}

\item{labels_x_nudge}{nudge x labels to the left}

\item{labels_y_nudge}{nudge y labels down}

\item{dayCol}{day boundary color}

\item{dayLwd}{day boundary line width (set to 0 to omit day lines)}

\item{dayLty}{day boundary type}

\item{hourCol}{hour boundary color}

\item{hourLwd}{hour boundary line width (set to 0 to omit  hour lines)}

\item{hourLty}{hour boundary type}

\item{hourInterval}{interval for hour boundary lines}

\item{...}{additional arguments to be passed to \code{barplot(})}
}
\description{
Creates a bar plot showing hourly PM 2.5 values for a specific monitor in a \emph{ws_monitor} object.
Colors are assigned to one of the following styles:
\itemize{
\item{\code{AQI} -- hourly values colored with AQI colors using AQI 24-hour breaks}
\item{\code{brownScaleAQI} -- hourly values colored with brownscale colors using AQI 24-hour breaks}
\item{\code{grayScaleAQI} -- hourly values colored grayscale colors using AQI 24-hour breaks}
}
}
\details{
The \code{labels_x_nudge} and \code{labels_y_nudge} can be used to 
tweak the date labeling. Units used are the same as those in the plot.
}
\examples{
C_V <- monitor_subset(Carmel_Valley, tlim=c(2016080800,2016081023),
                      timezone='America/Los_Angeles')
monitorPlot_hourlyBarplot(C_V, main='1-Hourly Average PM2.5',
                          labels_x_nudge=1, labels_y_nudge=0)
}
\keyword{ws_monitor}
