% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/airsis_ESAMQualityControl.R
\name{airsis_ESAMQualityControl}
\alias{airsis_ESAMQualityControl}
\title{Apply Quality Control to Raw AIRSIS E-Sampler Dataframe}
\usage{
airsis_ESAMQualityControl(df, valid_Longitude = c(-180, 180),
  valid_Latitude = c(-90, 90), remove_Lon_zero = TRUE,
  remove_Lat_zero = TRUE, valid_Flow = c(1.999, 2.001), valid_AT = c(-Inf,
  150), valid_RHi = c(-Inf, 55), valid_Conc = c(-Inf, 984))
}
\arguments{
\item{df}{single site dataframe created by \code{airsis_downloadData()}}

\item{valid_Longitude}{range of valid Longitude values}

\item{valid_Latitude}{range of valid Latitude values}

\item{remove_Lon_zero}{flag to remove rows where Longitude == 0}

\item{remove_Lat_zero}{flag to remove rows where Latitude == 0}

\item{valid_Flow}{range of valid Flow.l.m values}

\item{valid_AT}{range of valid AT.C. values}

\item{valid_RHi}{range of valid RHi... values}

\item{valid_Conc}{range of valid Conc.mg.m3. values}
}
\value{
Cleaned up dataframe of AIRSIS monitor data.
}
\description{
Perform various QC measures on AIRSIS E-Sampler data.

The following columns of data are tested against valid ranges:
\itemize{
\item{\code{Flow}}
\item{\code{AT}}
\item{\code{RHi}}
\item{\code{ConcHr}}
}

A \code{POSIXct datetime} column (UTC) is also added based on \code{Date.Time.GMT}.
}
\seealso{
\code{\link{airsis_qualityControl}}
}
\keyword{AIRSIS}

