% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv.bal.psa.R
\name{cv.bal.psa}
\alias{cv.bal.psa}
\title{Multiple Covariate Balance Assessment Plot}
\usage{
cv.bal.psa(
  covariates,
  treatment,
  propensity,
  strata = NULL,
  int = NULL,
  tree = FALSE,
  minsize = 2,
  universal.psd = TRUE,
  trM = 0,
  absolute.es = TRUE,
  trt.value = NULL,
  use.trt.var = FALSE,
  verbose = FALSE,
  xlim = NULL,
  plot.strata = TRUE,
  ...
)
}
\arguments{
\item{covariates}{Dataframe of covariates.  Factors should be recoded using
\code{cv.trans.psa}}

\item{treatment}{Binary vector or factor defining the two treatments}

\item{propensity}{Vector of same length as \code{treatment} containing
estimated propensity scores.}

\item{strata}{Either a vector of same length as \code{treatment} of
predefined stratum number, or one integer \code{n} used to assign rows to
\code{n} strata \code{propensity} scores, each of approximately the same
number of cases. If relatively few unique propensity scores have been
defined (as from a classification tree) then the logical \code{tree} should
be set equal to \code{TRUE}.}

\item{int}{Either a number \code{m} used to divide \code{[0,1]} into
\code{m} equal length subintervals, or a vector containing cut points
between 0 and 1 that define subintervals (perhaps as suggested by
loess.psa). In either case the subintervals define strata, for which sizes
can differ.}

\item{tree}{Logical, default \code{FALSE}.  If there are few unique
propensity scores, say from a recursively partitioned tree, then TRUE forces
strata to be defined by the unique propensity scores.}

\item{minsize}{Smallest allowable stratum-treatment size.  If violated, rows
in the stratum are removed.  User may wish to redefine strata.}

\item{universal.psd}{Logical, default = TRUE.  Forces standard deviations
used to be unadjusted for stratification.}

\item{trM}{Numeric, default = 0; passed to \code{mean} for trimming
purposes.}

\item{absolute.es}{Logical, default TRUE. If TRUE, graphic depicts absolute
values of all effect sizes.  Note that the adjusted effect size plotted is
the absolute value of weighted averages of the signed by-stratum effect size
values when \code{absolute.es} is TRUE.}

\item{trt.value}{Character string; if desired allows the name of an active
treatment to be given.  Should be a level (value) of the \code{treatment}
factor (vector).}

\item{use.trt.var}{Logical, default FALSE.  If TRUE, uses just active
treatment standard deviations for effect size, as per a suggestion of Rubin
and Stuart (see reference below).}

\item{verbose}{Logical, default FALSE.  Numerical output is returned
invisibly.}

\item{xlim}{Binary vector passed to plot for overriding default choices.
Default NULL.}

\item{plot.strata}{Logical, default TRUE.  Adds effect size values for
individual strata to graphic.}

\item{\dots}{Other graphical parameters passed to \code{plot}.}
}
\value{
Graphic plots covariate balance before and after stratication on
propensity scores.  The default version (absolute.es = TRUE) plots the
absolute values of effect sizes for each stratum, though the overall
estimate is the weighted mean before taking the absolute values.  Numerical
output consists of seven addressable objects.  If \code{verbose} is FALSE
(default), output is not printed. \item{original.strata}{Matrix of
strata-treatment counts as originally input.} \item{strata.used}{Matrix of
strata-treatment counts used in effectsize calculations after any
\code{minsize} reductions.} \item{mean.diff.strata.wtd}{Matrix of strata by
covariate weighted (by strata size) average differences.}
\item{mean.diff.unadj}{Matrix of covariate effects sizes before
stratification.} \item{effect.sizes}{Matrix of effect sizes by covariate and
statum.} \item{treatment.levels}{Names of treatments.}
\item{effects.strata.treatment}{Matrix of standard deviations and
stratum-treatment covariate means used to calculate the
\code{effect.sizes}.}
}
\description{
Provides a graphic that depicts covarite effect size differences between
treatment groups both before and after stratification.  Function will create
stata internally if desired, and returns numerical output used to create
graphic.
}
\details{
Effect sizes between treatments for each covariate are presented in one
graphic, both before and after stratification.
}
\examples{

data(lindner)
attach(lindner)
lindner.ps <- glm(abcix ~ stent + height + female +
      diabetic + acutemi + ejecfrac + ves1proc,
      data = lindner, family = binomial)
ps<-lindner.ps$fitted
lindner.cv <- lindner[,4:10]
cv.bal.psa(lindner.cv, abcix, ps, strata = 5)
cv.bal.psa(lindner.cv, abcix, ps, strata = 10)
cv.bal.psa(lindner.cv, abcix, ps, int = c(.2, .5, .6, .75, .8))

}
\references{
``Matching Methods for Causal Inference: A review and a look
forward." Forthcoming in Statistical Science.
}
\seealso{
\code{\link{cv.bal.psa}}, \code{\link{loess.psa}},
\code{\link{cstrata.psa}}, \code{\link{cv.trans.psa}}
}
\author{
Robert M. Pruzek \email{RMPruzek@yahoo.com}

James E. Helmreich \email{James.Helmreich@Marist.edu}

KuangNan Xiong \email{harryxkn@yahoo.com}
}
\keyword{hplot}
