#' Chronic Obstructive Pulmonary Disease (COPD) data
#'
#'  A subset of the COPDGene study data, obtained from the Gene Expression Omnibus database. This contains expression and clinical covariates data.
#'  All of the 28 genes contained in this data are identified as COPD-related by Sakornsakolpat et al. Nat Genet, 2019.
#'
#'
#' @docType data
#'
#' @usage data(combinedCOPDdat_RGO)
#'
#' @format `combinedCOPDdat_RGO`
#'
#' @keywords Application data used in Ahn et al. BMC Bioinformatics. 2023.
#'
#' @references Sakornsakolpat P, Prokopenko D, Lamontagne M, et al. Genetic landscape of chronic obstructive pulmonary disease identifies heterogeneous cell-type and phenotype associations. Nat Genet. 2019;51(3):494–505.
#' (\href{https://pubmed.ncbi.nlm.nih.gov/30804561/}{PubMed})
#' Ahn S, Grimes T, Datta S. A pseudo-value regression approach for differential network analysis of co-expression data. BMC Bioinformatics, 2023;24(1):8.
#' (\href{https://pubmed.ncbi.nlm.nih.gov/36624383/}{PubMed})
#'
#'
#' @examples
#' data(combinedCOPDdat_RGO)
#' combinedCOPDdat_RGO
"combinedCOPDdat_RGO"
