% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_MADE.mdes.R
\name{plot_MADE.mdes}
\alias{plot_MADE.mdes}
\title{Plot function for a 'mdes' object}
\usage{
\method{plot_MADE}{mdes}(
  data,
  v_lines = NULL,
  legend_position = "bottom",
  color = TRUE,
  numbers = TRUE,
  number_size = 2.5,
  numbers_ynudge = NULL,
  caption = TRUE,
  x_lab = NULL,
  x_breaks = NULL,
  x_limits = NULL,
  y_breaks = ggplot2::waiver(),
  y_limits = NULL,
  y_expand = NULL,
  warning = TRUE,
  traffic_light_assumptions = NULL,
  es_min = NULL,
  expected_studies = NULL,
  ...
)
}
\arguments{
\item{data}{Data/object for which the plot should be made.}

\item{v_lines}{Integer or vector to specify vertical line(s) in within each
plot. Default is \code{NULL}.}

\item{legend_position}{Character string to specify position of legend. Default is \code{"bottom"}.}

\item{color}{Logical indicating whether to use color in the plot(s). Default is \code{TRUE}.}

\item{numbers}{Logical indicating whether to number the plots. Default is \code{TRUE}.}

\item{number_size}{Integer value specifying the size of the (optional) plot
numbers. Default is \code{2.5}.}

\item{numbers_ynudge}{Integer value for vertical nudge of the (optional) plot
numbers.}

\item{caption}{Logical indicating whether to include a caption with detailed
information regarding the analysis. Default is \code{TRUE}.}

\item{x_lab}{Title for the x-axis. If \code{NULL} (the default), the x_lab is
specified automatically.}

\item{x_breaks}{Optional vector to specify breaks on the x-axis. Default is \code{NULL}.}

\item{x_limits}{Optional vector of length 2 to specify the limits of the
x-axis. Default is \code{NULL}, which allows limits to be determined automatically from the data.}

\item{y_breaks}{Optional vector to specify breaks on the y-axis.}

\item{y_limits}{Optional vector of length 2 to specify the limits of the
y-axis.}

\item{y_expand}{Optional vector to expand the limits of the y-axis. Default is \code{NULL}.}

\item{warning}{Logical indicating whether warnings should be returned when
multiple models appear in the data. Default is \code{TRUE}.}

\item{traffic_light_assumptions}{Optional logical to specify coloring of
strips of the facet grids to emphasize assumptions about the likelihood the
given analytical scenario. See Vembye, Pustejovsky, & Pigott (In
preparation) for further details.}

\item{es_min}{Optional integer or vector to specify a horizontal line or
interval, indicating a benchmark value or values for the minimum effect
size of practical concern (default is \code{NULL}).}

\item{expected_studies}{Optional vector of length 2 specifying a range for
the number of studies one expects to include in the meta-analysis. If
specified, this interval will be shaded across facet_grip plots (default is
\code{NULL}).}

\item{...}{Additional arguments available for some classes of objects.}
}
\value{
A \code{ggplot} plot showing the minimum detectable effect
size across the expected number of studies, faceted by the between-study and
within-study SDs, with different colors, lines, and shapes corresponding to
different values of the assumed sample correlation.
}
\description{
Creates a faceted plot for minimum detectable effect size (mdes)
analyses calculated using \code{mdes_MADE}.
}
\details{
In general, it can be rather difficult to guess/approximate the true
model parameters and sample characteristics a priori. Calculating the
minimum detectable effect size under just a single set of assumptions can
easily be misleading even if the true model and data structure only
slightly diverge from the yielded data and model assumptions. To maximize
the informativeness of the analysis, Vembye, Pustejovsky, & Pigott (In
preparation) suggest accommodating the uncertainty of the power
approximations by reporting or plotting minimum detectable effect size
estimates across a range of possible scenarios, which can be done using
\code{plot_MADE.mdes}.
}
\examples{
mdes_MADE(
  J = c(25, 35),
  tau = 0.05,
  omega = 0,
  rho = 0,
  target_power = .6,
  alpha = 0.1,
  sigma2_dist = 4 / 200,
  n_ES_dist = 8,
  seed = 10052510
) |>
  plot_MADE(expected_studies = c(28, 32), numbers = FALSE)



}
\references{
Vembye, M. H., Pustejovsky, J. E., & Pigott, T. D. (In
preparation). Conducting power analysis for meta-analysis of dependent
effect sizes: Common guidelines and an introduction to the POMADE R
package.
}
\seealso{
\code{\link{plot_MADE}}
}
