% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qmandelk.R
\name{Mandel-k}
\alias{Mandel-k}
\alias{qmandelk}
\alias{pmandelk}
\title{Mandel's k Distribution}
\usage{
qmandelk(p, k, n, lower.tail = TRUE, log.p = FALSE)

pmandelk(q, k, n, lower.tail = TRUE, log.p = FALSE)
}
\arguments{
\item{p}{vector of probabilities.}

\item{k}{number of groups.}

\item{n}{number of replicates per group.}

\item{lower.tail}{logical; if TRUE (default),
probabilities are \eqn{P[X \leq x]} otherwise, \eqn{P[X > x]}.}

\item{log.p}{logical; if \code{TRUE}, probabilities
are given as log(p).}

\item{q}{vector of quantiles.}
}
\value{
\code{pmandelk} gives the distribution function and
\code{qmandelk} gives the quantile function.
}
\description{
Distribution function and quantile function
for Mandel's k distribution.
}
\note{
The functions are only appropriate for balanced designs.
}
\section{Source}{

The code for \code{pmandelk} was taken from:\cr
Stephen L R Ellison. (2017). metRology: Support for Metrological
Applications. R package version 0.9-26-2.
\url{https://CRAN.R-project.org/package=metRology}
}

\examples{
qmandelk(0.005, 7, 3, lower.tail=FALSE)
}
\references{
Practice E 691 (2005) \emph{Standard Practice for
Conducting an Interlaboratory Study to Determine the
Precision of a Test Method}, ASTM International.
}
\seealso{
\code{\link{mandelkTest}}

\code{\link{pmandelh}}, \code{\link{qmandelh}}
}
\keyword{distribution}
