% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PLNfit-S3methods.R
\name{predict_cond}
\alias{predict_cond}
\alias{predict_cond.PLNfit}
\title{Predict counts conditionally}
\usage{
predict_cond(
  object,
  newdata,
  cond_responses,
  type = c("link", "response"),
  var_par = FALSE
)

\method{predict_cond}{PLNfit}(
  object,
  newdata,
  cond_responses,
  type = c("link", "response"),
  var_par = FALSE
)
}
\arguments{
\item{object}{an R6 object with class \code{\link{PLNfit}}}

\item{newdata}{A data frame in which to look for variables and offsets with which to predict}

\item{cond_responses}{a data frame containing the counts of the observed variables (matching the names provided as data in the PLN function)}

\item{type}{The type of prediction required. The default is on the scale of the linear predictors (i.e. log average count)}

\item{var_par}{Boolean. Should new estimations of the variational parameters of mean and variance be sent back, as attributes of the matrix of predictions. Default to \code{FALSE}.}
}
\value{
A list containing:
\item{pred}{A matrix of predicted log-counts (if \code{type = "link"}) or predicted counts (if \code{type = "response"})}
\item{M}{A matrix containing E(Z_uncond | Y_c) for each given site.}
\item{S}{A matrix containing Var(Z_uncond | Y_c) for each given site (sites are the third dimension of the array)}
}
\description{
Predict counts of a new sample conditionally on a (set of) observed variables
}
\section{Methods (by class)}{
\itemize{
\item \code{predict_cond(PLNfit)}: Predict counts of a new sample conditionally on a (set of) observed variables for a \code{\link{PLNfit}}

}}
\examples{
data(trichoptera)
trichoptera_prep <- prepare_data(trichoptera$Abundance, trichoptera$Covariate)
myPLN <- PLN(Abundance ~ Temperature + Wind, trichoptera_prep)
#Condition on the set of the first two species in the dataset (Hym, Hys) at the ten first sites
Yc <- trichoptera$Abundance[1:10, c(1, 2), drop=FALSE]
newX <- cbind(1, trichoptera$Covariate[1:10, c("Temperature", "Wind")])
pred <- predict_cond(myPLN, newX, Yc, type = "response")
}
