% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PLNPCAfamily-S3methods.R
\name{plot.PLNPCAfamily}
\alias{plot.PLNPCAfamily}
\title{Display the criteria associated with a collection of PLNPCA fits (a PLNPCAfamily)}
\usage{
\method{plot}{PLNPCAfamily}(x, criteria = c("loglik", "BIC", "ICL"),
  annotate = TRUE, ...)
}
\arguments{
\item{x}{an R6 object with class PLNfamily}

\item{criteria}{vector of characters. The criteria to plot in c("loglik", "BIC", "ICL", "R_squared").
Default is  c("loglik", "BIC", "ICL").}

\item{annotate}{logical: should the value of approximated R squared be added to the plot?}

\item{...}{additional parameters for S3 compatibility. Not used}
}
\value{
Produces a plot  representing the evolution of the criteria of the different models considered,
highlighting the best model in terms of BIC and ICL (the greater, the better).
These criteria have the form 'loglik - 1/2 * penalty' so that they are on the same scale as the model loglikelihood.
}
\description{
Display the criteria associated with a collection of PLNPCA fits (a PLNPCAfamily)
}
\examples{
data(trichoptera)
trichoptera <- prepare_data(trichoptera$Abundance, trichoptera$Covariate)
myPCAs <- PLNPCA(Abundance ~ 1 + offset(log(Offset)), data = trichoptera, ranks = 1:5)
\dontrun{
plot(myPCAs)
}
}
