% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PLNLDAfit-class.R
\docType{data}
\name{PLNLDAfit}
\alias{PLNLDAfit}
\title{An R6 Class to represent a PLNfit in a LDA framework}
\format{An object of class \code{R6ClassGenerator} of length 24.}
\usage{
PLNLDAfit
}
\description{
The function \code{\link{PLNLDA}} produces an instance of an object with class \code{PLNPLDAfit}.

This class comes with a set of methods, some of them being useful for the user:
See the documentation for the methods inherited by  \code{\link[=PLNfit]{PLNfit}}, the
\code{\link[=plot.PLNLDAfit]{plot.PLNPCAfit}} method for LDA vizualization and
\code{\link[=predict.PLNLDAfit]{predict.PLNPCAfit}} method for prediction
}
\section{Fields}{

\describe{
\item{\code{rank}}{the dimension of the current model}

\item{\code{model_par}}{a list with the matrices associated with the estimated parameters of the PLN model: Theta (covariates), Sigma (latent covariance), B (latent loadings), P (latent position) and Mu (group means)}

\item{\code{var_par}}{a list with two matrices, M and S, which are the estimated parameters in the variational approximation}

\item{\code{optim_par}}{a list with parameters useful for monitoring the optimization}

\item{\code{loglik}}{variational lower bound of the loglikelihood}

\item{\code{BIC}}{variational lower bound of the BIC}

\item{\code{ICL}}{variational lower bound of the ICL}

\item{\code{R_squared}}{approximated goodness-of-fit criterion}

\item{\code{criteria}}{a vector with loglik, BIC, ICL, R_squared and number of parameters}

\item{\code{nb_param}}{number of parameters in the current PLN model}

\item{\code{percent_var}}{the percent of variance explained by each axis}

\item{\code{corr_map}}{a matrix of correlations to plot the correlation circles}

\item{\code{scores}}{a matrix of scores to plot the individual factor maps}
}}

\examples{
\dontrun{
data(trichoptera)
trichoptera <- prepare_data(trichoptera$Abundance, trichoptera$Covariate)
myPLNLDA <- PLNLDA(Abundance ~ 1, grouping = Group, data = trichoptera)
class(myPLNLDA)
print(myPLNLDA)
}
}
\seealso{
The function \code{\link{PLNLDA}}.
}
\keyword{datasets}
