% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_date.R
\name{plot_date}
\alias{plot_date}
\title{Plot SpatRaster with date serial number/time attribute}
\usage{
plot_date(x, breaks = NULL, ...)
}
\arguments{
\item{x}{SpatRaster - numeric - value is serial number or SpatRaster - logical - with time attribute}

\item{breaks}{number of breaks in the legend - numeric}

\item{...}{arguments for terra::plot function, except (type, breaks, col or plg)}
}
\value{
A plot of a phenological event by day with legend.
}
\description{
A wrapper around terra::plot to show the time serial number as a character date in the legend.
}
\examples{

data <- load_test()
budswelling <- phenology(data, "budswelling", "quercus_robur_clone256_type1", 2020)
plot_date(budswelling)
}
\seealso{
Other Plot: 
\code{\link{plot_stages}()},
\code{\link{plot_station_step}()},
\code{\link{plot_station}()}
}
\concept{Plot}
