% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cleanOutliers.R
\name{cleanOutliers}
\alias{cleanOutliers}
\title{Clean Returns Outliers}
\usage{
cleanOutliers(x, k = 3, shrink = TRUE)
}
\arguments{
\item{x}{A numeric vector}

\item{k}{A numeric value, which multiplies the mad.  Smaller values of k
result in greater fractions of data which is either shrunk of rejected,
and larger values of k result in smaller fractions of the data that are
shrunk or rejected.}

\item{shrink}{A logical variable whose default is TRUE.}
}
\value{
an outlier cleaned numeric object
}
\description{
Outliers are "cleaned" by shrinking or rejecting data whose
distance from the median (med) is larger in absolute value than a specified
value k multiplied by the median absolute deviation from the median (mad).
Outlier shrinkage results in the data value being set equal to the nearest
of med-k*mad and med+k*mad. Rejected data is assigned an NA. Shrinkage is
the default.
}
\examples{
args(cleanOutliers)
}
