% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BenchmarkRvsCpp.R
\name{MiniBenchmarkRvsCpp}
\alias{MiniBenchmarkRvsCpp}
\title{Evaluate the likelihood calculation times for example trees and data}
\usage{
MiniBenchmarkRvsCpp(
  data = PCMBaseCpp::benchmarkData,
  includeR = TRUE,
  includeTransformationTime = TRUE,
  nRepsCpp = 10L,
  listOptions = list(PCMBase.Lmr.mode = 11, PCMBase.Threshold.EV = 0,
    PCMBase.Threshold.SV = 0),
  doProf = FALSE,
  RprofR.out = "RprofR.out",
  RprofCpp.out = "RprofCpp.out"
)
}
\arguments{
\item{data}{a `data.frame` with at least the following columns: 
\describe{
\item{tree: }{a list column of phylo objects with an edge.part member set.}
\item{X: }{a list column of k x N numerical matrices.}
\item{model: }{a list column of PCM objects.}
}
Defaults: to `benchmarkData`, which is small data.table included
with the PCMBaseCpp package.}

\item{includeR}{logical (default TRUE) indicating if likelihood calculations
in R should be included in the benchmark (can be slow).}

\item{includeTransformationTime}{logical (default TRUE) indicating if the time for
\code{\link[PCMBase]{PCMApplyTransformation}} should be included in the benchmark.}

\item{nRepsCpp}{: number of repetitions for the cpp likelihood calculation 
calls: a bigger value increases the precision of time estimation at the 
expense of longer running time for the benchmark. Defaults to 10.}

\item{listOptions}{options to set before measuring the calculation times. 
Defaults to `list(PCMBase.Lmr.mode = 11, PCMBase.Threshold.EV = 0, PCMBase.Threshold.SV = 0)`. 
`PCMBase.Lmr.mode` corresponds to the parallel traversal mode for the tree 
traversal algorithm (see 
\href{https://venelin.github.io/SPLITT/articles/SPLITTTraversalModes.html}{this page}
for possible values).}

\item{doProf}{logical indicating if profiling should be activated (see Rprof
from the utils R-package). Default: FALSE. Additional arguments to Rprof can 
be specified by assigning lists of arguments to the options 'PCMBaseCpp.ArgsRprofR'
and 'PCMBaseCpp.ArgsRprofCpp'. The default values for both options is
\code{list(append = TRUE, line.profiling = TRUE)}.}

\item{RprofR.out, RprofCpp.out}{character strings indicating Rprof.out files 
for the R and Cpp implementations; ignored if doProf is FALSE. Default values:
'RprofR.out' and 'Rprofcpp.out'.}
}
\value{
a data.frame.
}
\description{
Evaluate the likelihood calculation times for example trees and data
}
\examples{
library(PCMBase)
library(PCMBaseCpp)
library(data.table)

testData <- PCMBaseCpp::benchmarkData[1]
# original MGPM model
MiniBenchmarkRvsCpp(data = testData)

# original MGPM model and parallel mode
MiniBenchmarkRvsCpp(
data = testData,
listOptions = list(PCMBase.Lmr.mode = 21, PCMBase.Threshold.EV = 1e-9, 
PCMBase.Threshold.SV = 1e-9))

# single-trait data, original MGPM model and single mode and enabled option 
# PCMBase.Use1DClasses
MiniBenchmarkRvsCpp(
data = PCMBaseCpp::benchmarkData[1, list(
 tree, 
 X = lapply(X, function(x) x[1,, drop=FALSE]), 
 model = lapply(model, function(m) PCMExtractDimensions(m, dims = 1)))],
listOptions = list(
  PCMBase.Lmr.mode = 11, 
  PCMBase.Threshold.EV = 1e-9, 
  PCMBase.Threshold.SV = 1e-9,
  PCMBase.Use1DClasses = FALSE))

}
