% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getnfac.r
\name{getnfac}
\alias{getnfac}
\title{Determining The Number of Factors In Approximate Factor Model}
\usage{
getnfac(x,kmax,criteria)
}
\arguments{
\item{x}{A matrix containing the data.}

\item{kmax}{An integer with the maximum number of common factors to search over. This methodology
is weak to underestimation of the number of common factors so setting this value higher is preferred.}

\item{criteria}{a character vector of length one with values of either IC1, IC2, IC3, AIC1, BIC1, AIC3, BIC3, or eigen.
Choosing eigen makes the number of factors equal to the number of columns whose sum of eigenvalues is less than  or equal to .5.}
}
\value{
ic Integer of the approximate number of factors based off of the chosen
penalty function

lambda A matrix of the estimated factor loadings associated with common factors.

Fhat A matrix of the estimated common components
}
\description{
This function approximates the number of factors in an approximate factor model
 for large N by T matrices using the methods and criteria found in Bai and Ng (2002)
}
\details{
This function approximates the number of factors in an approximate
factor model. Amongst the penalty functions BIC(3) has been found to be
strict against cross-sectional dependence and is recommended for panels with greater than 18 series.
 IC(1) is most commonly used. BIC(1) is not recommended for small N relative to T. AIC(3) and BIC(3) take into
account the panel structure of the data. AIC(3) performs consistently
across configurations of the data while BIC(3) performs better on
large N data sets.
}
\references{
Jushan Bai and Serena Ng. 'Determining the Number of Factors in
Approximate Factor Models.' Econometrica 70.1 (2002): 191-221. Print.
}

