% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addAISSummary.R
\name{addAISSummary}
\alias{addAISSummary}
\title{Add AIS Data Summary to Dataframe}
\usage{
addAISSummary(x, ais, distance = 10000)
}
\arguments{
\item{x}{a dataframe with \code{UTC}, \code{Latitude}, and \code{Longitude}
columns}

\item{ais}{AIS data created using the \link{readLocalAIS} function. Can also
be a character listing the directory of AIS}

\item{distance}{distance (meters) within locations in \code{x} to mark
as "nearby"}
}
\value{
a dataframe with AIS summary data added. Will contain new columns
\describe{
\item{nShips}{the number of ships within "distance" at this time}
\item{meanDist}{average distance of nearby ships, NA if none}
\item{meanSOG}{average speed over ground of nearby ships, NA if none}
\item{closeDist}{distance of the closest ship, NA if none}
\item{closeSOG}{speed over ground of closest ship, NA if none}
}
}
\description{
Adds a summary of matching AIS data for nearby vessels
to a data. Information added includes number of vessels, distance
to nearby vessels, and average speed of nearby vessels
}
\examples{

gps <- data.frame(Latitude=c(33.2, 33.5,33.6),
                  Longitude=c(-118.1, -118.4, -119),
                  UTC=as.POSIXct(
                    c('2022-04-28 05:00:00',
                      '2022-04-28 10:00:00',
                      '2022-04-28 20:00:00'),
                    tz='UTC'))
ais <- readLocalAIS(gps, system.file('extdata/ais', package='PAMscapes'))
aisSummary <- addAISSummary(gps, ais)
str(aisSummary)

}
\author{
Taiki Sakai \email{taiki.sakai@noaa.gov}
}
