% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PAC.R
\name{PAC}
\alias{PAC}
\title{Partition Assisted Clustering 
PAC 1) utilizes dsp or bsp-ll to recursively partition the data space and 2) applies a short round of kmeans style postprocessing to efficiently output clustered labels of data points.}
\usage{
PAC(data, K, maxlevel = 40, method = "dsp", max.iter = 50)
}
\arguments{
\item{data}{a n x p data matrix}

\item{K}{number of final clusters in the output}

\item{maxlevel}{the maximum level of the partition}

\item{method}{partition method, either "dsp(discrepancy based partition)",  or "bsp(bayesian sequantial partition)"}

\item{max.iter}{maximum iteration for the kmeans step}
}
\value{
y        cluter labels for the input
}
\description{
Partition Assisted Clustering 
PAC 1) utilizes dsp or bsp-ll to recursively partition the data space and 2) applies a short round of kmeans style postprocessing to efficiently output clustered labels of data points.
}
\examples{
n = 5e3                       # number of observations
p = 1                         # number of dimensions
K = 3                         # number of clusters
w = rep(1,K)/K                # component weights
mu <- c(0,2,4)                # component means
sd <- rep(1,K)/K              # component standard deviations
g <- sample(1:K,prob=w,size=n,replace=TRUE)   # ground truth for clustering
X <- as.matrix(rnorm(n=n,mean=mu[g],sd=sd[g]))
y <- PAC(X, K)
print(fmeasure(g,y))
}

