% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GloptiPolyRegion.R
\name{GloptiPolyRegion}
\alias{GloptiPolyRegion}
\title{Confidence region for optima of up to cubic polynomial models (up to 5 regressors)}
\usage{
GloptiPolyRegion(X, y, degree, lb, ub, B = 200, alpha = 0.05,
  maximization = TRUE, axes_labels = NULL,
  outputPDFFile = "CRplot.pdf", verbose = TRUE)
}
\arguments{
\item{X}{numeric matrix of shape (N, k); N is the sample size; k is the
number of variables, which can be 2, 3, 4 and 5; X specifies the
design matrix}

\item{y}{numeric vector of shape (N, 1); y specifies the responses}

\item{degree}{integer scalor; degree specifies the order of the polynomial
model, which can be 2 or 3}

\item{lb}{numeric vector of shape (1, k); lb specifies the lower bounds for
the k variables}

\item{ub}{numeric vector of shape (1, k); ub specifies the upper bounds for
the k variables}

\item{B}{integer scalor; B specifies the number of bootstrap operations}

\item{alpha}{numeric scalor between 0 and 1; alpha specifies the nominal
confidence level, 1 - alpha, of the confidence region}

\item{maximization}{boolean scalor; if specifies whether the algorithm
computes the confidence region for the maxima or minima}

\item{axes_labels}{vector of strings; it specifies the name of each experimental factor
to be displayed on the CR plot; the default value is NULL, when
the labels will be set to x1, x2, ...}

\item{outputPDFFile}{name of the PDF file where the CR plot is saved
(default: "CR_plot.pdf")}

\item{verbose}{boolean scalor; it specifies whether to display running status}
}
\value{
Upon completion, a figure displaying the confidence region of the true optimum
        projected onto each pairwise-variable planes will be created (a pdf file will
        also be generated), and the function also returns a list consisting of
        2 components:
        \describe{
          \item{boot_optima}{numeric matrix of shape ((1 - alpha)B, k);
                             it contains the (1 - alpha)B bootstrap optima}
          \item{bagged_optimum}{numeric vector of shape (1, k); the bagged
                                optimum; computed by taking the column average
                                of boot_optima}
        }
}
\description{
Computes and displays an approximated (1 - alpha) confidence region (CR) for
the bound-constrained maximum of a polynomial regression model in up to cubic order
with up to 5 controllable factors
\insertCite{DelCastilloCR}{OptimaRegion}.
}
\section{Author(s)}{

Enrique del Castillo \email{exd13@psu.edu},
Peng Chen \email{pfc5098@psu.edu},
Adam Meyers \email{akm5733@psu.edu},
John Hunt \email{J.Hunt@exeter.ac.uk} and
James Rapkin \email{jr297@exeter.ac.uk}.
}

\examples{
\dontrun{
# Example 1: run GloptiPolyRegion on a quadratic, 3 vars example
out <- GloptiPolyRegion(
  X = quad_3D[, 1:3], y = quad_3D[, 4], degree = 2,
  lb = c(-2, -2, -2), ub = c(2, 2, 2), B = 500, alpha = 0.1,
  maximization = TRUE,
  outputPDFFile = "CR_quad_3D.pdf", verbose = TRUE
)
# check result
str(out)

# Example 2: run GloptiPolyRegion on a cubic, 5 vars example
out <- GloptiPolyRegion(
  X = cubic_5D$design_matrix, y = cubic_5D$response,
  degree = 3, lb = rep(0, 5), ub = rep(5, 5), B = 200,
  alpha = 0.05, maximization = TRUE,
  outputPDFFile = "CR_cubic_5D.pdf", verbose = TRUE
)
# check result
str(out)
}
}
\references{
{
 \insertAllCited{}
}
}
