% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loadOMLConfig.R
\name{loadOMLConfig}
\alias{loadOMLConfig}
\title{Load OpenML configuration.}
\usage{
loadOMLConfig(path = "~/.openml/config", assign = TRUE)
}
\arguments{
\item{path}{[\code{character(1)}]\cr
Full path location of the config file to be loaded.}

\item{assign}{[\code{logical(1)}]\cr
Use the loaded configuration as the current configuration?
If set to \code{FALSE}, the configuration is just returned by the function.
Default is \code{TRUE}.}
}
\value{
\code{list} of current configuration variables with class \dQuote{OMLConfig}.
}
\description{
Loads the OpenML config file from the disk and overwrites the
current OpenML config.
If there is no API key in the configuration file, the key is retrieved from the
environment variable \dQuote{OPENMLAPIKEY} (if defined).
}
\examples{
# if assign = FALSE nothing is changed
# usually one would want assign = TRUE
\dontrun{
  loadOMLConfig(assign = FALSE)
}
}
\seealso{
Other config: \code{\link{configuration}},
  \code{\link{getOMLConfig}}, \code{\link{saveOMLConfig}},
  \code{\link{setOMLConfig}}
}
