% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setOMLConfig.R
\name{setOMLConfig}
\alias{setOMLConfig}
\title{Settter for configuration settings.}
\usage{
setOMLConfig(server = NULL, verbosity = NULL, apikey = NULL,
  cachedir = NULL, arff.reader = NULL, confirm.upload = NULL)
}
\arguments{
\item{server}{[\code{character(1)}]\cr
URL of the XML API endpoint.}

\item{verbosity}{[\code{integer(1)}]\cr
Verbosity level. Possible values are 0 (normal output), 1 (info output),
2 (debug output).}

\item{apikey}{[\code{character(1)}]\cr
Your OpenML API key. Log in to OpenML, move to your profile to get it.}

\item{cachedir}{[\code{character(1)}]\cr
Path to the cache directory.}

\item{arff.reader}{[\code{character(1)}]\cr
Name of the package which should be used to parse arff files. Possible are
\dQuote{RWeka}, which is the default and \dQuote{farff}.}

\item{confirm.upload}{[\code{logical(1)}]\cr
Should the user be asked for confirmation before upload of OML objects?}
}
\value{
Invisibly returns a list of configuration settings.
}
\description{
Set and overwrite configuration settings.
}
\seealso{
Other config: \code{\link{configuration}},
  \code{\link{getOMLConfig}}, \code{\link{loadOMLConfig}},
  \code{\link{saveOMLConfig}}
}

