% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zzz.R
\name{plot_simon_study_state}
\alias{plot_simon_study_state}
\title{Plots the study state of a given Simon's two-stage design.}
\usage{
plot_simon_study_state(sr, enrolledPat = data.frame(ep1 = logical()), r1, n1,
  r, n)
}
\arguments{
\item{sr}{dataframe containing the stopping rules for the given Simon's two-stage design defined by two columns named "Enrolled_patients" and "Needed_responses_ep1".
This way each row defines when the study has to be stopped for futility.}

\item{enrolledPat}{dataframe defined by a boolean vector in one column named "ep1" indicating which patient had a response.}

\item{r1}{critical value for the first stage.}

\item{n1}{sample size for the first stage.}

\item{r}{critical value for the subset endpoint.}

\item{n}{overall sample size.}
}
\description{
Plots the study state of a given Simon's two-stage design displaying the already enrolled patients and the stopping rules.
}
\examples{
#Calculate a Simon's two-stage design
design <- getSolutions()$Solutions[3,] #minimax-design for the default values.
#Define the stopping rules according to the chosen design
sr <- data.frame(Enrolled_patients = c(design$n1, design$n),
Needed_responses_ep1 = c(design$r1, design$r))
#Simulate 18 random generated outcomes.
enrolledPat <- data.frame(ep1 = rbinom(18,1, design$p1))
#Plot study state
plot_simon_study_state(sr, enrolledPat, design$r1, design$n1, design$r, design$n)
}
