% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summariseObservationPeriod.R
\name{summariseObservationPeriod}
\alias{summariseObservationPeriod}
\title{Summarise the observation period table getting some overall statistics in a
summarised_result object.}
\usage{
summariseObservationPeriod(
  observationPeriod,
  estimates = c("mean", "sd", "min", "q05", "q25", "median", "q75", "q95", "max",
    "density"),
  ageGroup = NULL,
  sex = FALSE,
  dateRange = NULL
)
}
\arguments{
\item{observationPeriod}{observation_period omop table.}

\item{estimates}{Estimates to summarise the variables of interest (
\verb{records per person}, \verb{duration in days} and
\verb{days to next observation period}).}

\item{ageGroup}{A list of age groups to stratify results by.}

\item{sex}{Boolean variable. Whether to stratify by sex (TRUE) or not
(FALSE).}

\item{dateRange}{A list containing the minimum and the maximum dates
defining the time range within which the analysis is performed.}
}
\value{
A summarised_result object with the summarised data.
}
\description{
Summarise the observation period table getting some overall statistics in a
summarised_result object.
}
\examples{
\donttest{
library(dplyr, warn.conflicts = FALSE)

cdm <- mockOmopSketch(numberIndividuals = 100)

result <- summariseObservationPeriod(cdm$observation_period)

result |>
  glimpse()

PatientProfiles::mockDisconnect(cdm)
}
}
