/*
 * Decompiled with CFR 0.152.
 */
package org.andwellness.xml.datagenerator;

import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.andwellness.xml.datagenerator.generator.MobilityMessageGenerator;
import org.andwellness.xml.datagenerator.generator.MobilityMessageGeneratorFactory;
import org.andwellness.xml.datagenerator.utility.DateIterator;
import org.andwellness.xml.datagenerator.utility.JSONUtility;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONException;

public class MobilityGenerator {
    public static void main(String[] args) {
        Date startDate = null;
        Date endDate = null;
        Calendar cal = Calendar.getInstance();
        BufferedWriter outWriter = null;
        double maxLat = 90.0;
        double minLat = -90.0;
        double maxLon = 180.0;
        double minLon = -180.0;
        int secondsBetween = 60;
        int numDays = 7;
        BasicConfigurator.configure();
        Logger.getRootLogger().setLevel(Level.INFO);
        if (args.length < 8) {
            MobilityGenerator.usage();
            System.exit(1);
        }
        String outFileName = args[0];
        String messageType = args[1];
        if (!MobilityGenerator.validMessageType(messageType)) {
            throw new IllegalArgumentException("incorrect/unknown message type: " + messageType);
        }
        try {
            secondsBetween = Integer.parseInt(args[2]);
            numDays = Integer.parseInt(args[3]);
            maxLat = Double.parseDouble(args[5]);
            minLat = Double.parseDouble(args[6]);
            maxLon = Double.parseDouble(args[7]);
            minLon = Double.parseDouble(args[8]);
            if (minLon < -180.0 || maxLon > 180.0) {
                System.err.println("Longitude is out of range -180 to 180");
                System.exit(1);
            }
            if (minLat < -90.0 || maxLat > 90.0) {
                System.err.println("Latitude is out of range -90 to 90");
                System.exit(1);
            }
        }
        catch (NumberFormatException e) {
            System.err.println(e.getMessage());
            MobilityGenerator.usage();
            System.exit(1);
        }
        String lastDateString = args[4];
        if ("today".equals(lastDateString)) {
            endDate = new Date();
        } else {
            SimpleDateFormat format = new SimpleDateFormat("MM-dd-yyyy");
            try {
                endDate = format.parse(lastDateString);
            }
            catch (ParseException e) {
                System.err.println("Cannot parse endDate: " + lastDateString);
                System.exit(1);
            }
        }
        MobilityMessageGenerator mobilityMessageGenerator = MobilityMessageGeneratorFactory.make(messageType);
        cal.setTime(endDate);
        cal.add(5, -numDays);
        startDate = cal.getTime();
        JSONArray mobilityJSONArray = new JSONArray();
        DateIterator dateIter = new DateIterator(startDate, endDate, 13, secondsBetween);
        try {
            while (dateIter.hasNext()) {
                Date date = (Date)dateIter.next();
                mobilityJSONArray.put(mobilityMessageGenerator.createMessage(date, maxLon, minLon, maxLat, minLat));
            }
        }
        catch (JSONException err) {
            err.printStackTrace();
            System.exit(1);
        }
        try {
            outWriter = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(outFileName)));
            JSONUtility.JSONWriter(outWriter, mobilityJSONArray, false);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            System.exit(1);
        }
        catch (JSONException e) {
            e.printStackTrace();
            System.exit(1);
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(1);
        }
        System.exit(0);
    }

    private static void usage() {
        System.out.println("Generates JSON of mobility data to upload to the AndWellness 2.0 server.");
        System.out.println();
        System.out.println("Usage: java -jar andwellness-mobility-generator-$version.jar $outfile $mobilityType $secondsBetween $numDays $lastDay $maxLat $minLat $maxLon $minLon");
        System.out.println("\t$outFile - The output filename.");
        System.out.println("\t$mobilityType - [mobility:mode_only | mobility:mode_extended]");
        System.out.println("    $secondsBetween - The number of seconds between data points.");
        System.out.println("    $numDay - The number of days of data to generate, starting now and working backwards.");
        System.out.println("    $lastDay - The last day of data generated, format: [today | MM-DD-YYYY]");
        System.out.println("    $maxLat - The maximum latitude value to generate.");
        System.out.println("    $minLat - The minimum latitude value to generate.");
        System.out.println("    $maxLon - The minimum longitude value to generate.");
        System.out.println("    $minLon - The minimum longitude value to generate.");
    }

    private static boolean validMessageType(String messageType) {
        return "mobility:mode_only".equals(messageType) || "mobility:mode_extended".equals(messageType);
    }
}

