% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SegFunctions.R
\name{MCTest}
\alias{MCTest}
\title{A function to test segregation indices using Monte Carlo simulations}
\usage{
MCTest(x, fun, simtype = "rand", proba = NULL, delta = 0.5, ptype = "int", 
variant = "s", distin = "m", distout = "m", itype = "multi", exact = F, 
diagval = "0", spatmat = "c", c = NULL, queen = TRUE, b = NULL, p = NULL, 
a = NULL, d = NULL, dc = NULL, fdist = "e", center = 1, nsim = 99, 
spatobj = NULL, folder = NULL, shape = NULL)
}
\arguments{
\item{x}{- an object of class matrix (or which can be coerced to that class), 
where each column represents the distribution of a population group, within 
spatial units. The number of columns should be greater than 1 (at least 2 
population groups are required). You should not include a column with total 
population in each unit, because this will be interpreted as a group.}

\item{fun}{- a character vector with the segregation function 
to be tested (only one-group or multigroup indexes)}

\item{simtype}{- a character vector with type of simulation. 
If simtype='perm', the function will use the permutation test. 
If simtype='rand', the population is realocated in the spatial 
units randomly. If simtype='area', the location probabilities 
are proportional to the spatial units' area. For the default 
value type='user', the function expects you to introduce a 
probability location vector.}

\item{proba}{- a vector with location probabilities. By 
default proba = NULL being calculated depending on the 
simulation type. The parameter is necessary when a user method 
is specified.}

\item{delta}{- a specific Atikinson inequality aversion parameter,
by default equal to 0.5,varying from 0 to 1.}

\item{ptype}{- a string variable giving two options for perimeter 
calculation, when needed: 'int' to use only interior
boundaries of spatial units, and 'all' to use entire boundaries, 
including the boundaries to the exterior of the area}

\item{variant}{- a character variable that allows to choose the Wong's index 
version: variant = 's' for the index adjusted for contiguous spatial units 
boundary lengths and perimeter/area ratio (by default) and variant = 'w' 
for the version based only on shared boundaries length}

\item{distin}{- input metric conversion, based on  \pkg{bink} package and 
includes conversions from 'm', 'km', 'inch', 'ft', 'yd', 'mi', 'naut_mi', etc.}

\item{distout}{- output metric conversion, based on  \pkg{bink} package and 
includes conversions to 'm', 'km', 'inch', 'ft', 'yd', 'mi', 'naut_mi', etc.}

\item{itype}{- a character string defining the type of some proximity indices:
itype = 'multi' (by default) for the multigroup index (White, 1986) or
itype = 'one' for the one-group version (Apparicio et al, 2008)}

\item{exact}{- a logical variable to specifiy the version of interaction indices 
exact = FALSE (by default) for the approximate version of the index, 
and exact = TRUE for the exact version}

\item{diagval}{- when providing a spatial object or a shape file, 
the user has the choice of the spatial matrix diagonal definition: 
diagval = '0' (by default) for an null diagonal and diagval = 'a' 
to compute the diagonal as 0.6 * square root (spatial units area) (White, 1983)}

\item{spatmat}{- the method used for some spatial calculations: 'c' for the 
contiguity matrix (by default) or any other user spatial interaction matrix 
and 'd' for the inverse exponential function of the distance.}

\item{c}{- a standard binary contiguity (adjacency) symmetric matrix where 
each element \emph{Cij} equals 1 if \emph{i}-th and \emph{j}-th spatial 
units are adjacent, and 0 otherwise.}

\item{queen}{- logical parameter difining criteria used for contiguity 
matrix computation, TRUE (by default) for queen , FALSE for rook}

\item{b}{- a common boundaries matrix where each element \emph{Bij} 
equals the shared boundary of \emph{i}-th and \emph{j}-th spatial units.}

\item{p}{- a numeric vector containing the perimeters of spatial units}

\item{a}{- a numeric vector containing the areas of spatial units}

\item{d}{- a matrix of the distances between spatial unit centroids}

\item{dc}{- a numeric vector containing the distances between spatial units 
centroids and the central spatial unit}

\item{fdist}{- the method used for distance interaction matrix: 
e' for inverse exponential function (by default) and 'l' for linear.}

\item{center}{- a numeric value giving the number of the spatial unit that 
represents the centre in the table}

\item{nsim}{- the number of simulations}

\item{spatobj}{- a spatial object (SpatialPolygonsDataFrame) containing 
geographic information}

\item{folder}{- a character vector with the folder (directory) 
name indicating where the shapefile with the geographic information 
is located.}

\item{shape}{- a character vector with the shape file name}
}
\value{
A list with thre elements: index's name, a Summary of the simulation
and index simulated distribution
}
\description{
The Monte Carlo tests for one-group or multigroup 
segregation indexes.
}
\examples{
x <- segdata@data[ ,1:2]
foldername <- system.file('extdata', package = 'OasisR')
shapename <- 'segdata'
ar <- area(segdata)
probavector<-ar/sum(ar)

MCTest (x, fun='ISMorrill', simtype = 'perm', spatobj = segdata)

MCTest (x, fun='ISMorrill', simtype = 'rand', spatobj = segdata)

MCTest (x, fun='ISMorrill', simtype = 'area', spatobj = segdata)

MCTest (x, fun='ISMorrill', simtype='user', proba = probavector, 
spatobj = segdata)

}
\references{
Tivadar M., Schaeffer Y, Torre A. and Bray F. (2014) 
\emph{OASIS - un Outil d'Analyse de la Segregation et des Inegalites 
Spatiales}.  Cybergeo : European Journal of Geography, GeOpenMod, 
document 699
}
\seealso{
\code{\link{MCPlot}}
}

