% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SegFunctions.R
\name{HLoc}
\alias{HLoc}
\title{A function to compute local diversity index}
\usage{
HLoc(x)
}
\arguments{
\item{x}{- an object of class matrix (or which can be coerced to that class), 
where each column represents the distribution of a population group, within 
spatial units. The number of columns should be greater than 1 (at least 2 
population groups are required). You should not include a column with total 
population in each unit, because this will be interpreted as a group.}
}
\value{
a numeric vector containing  diversity index value for 
each population group
}
\description{
Local diversity index, HLoc, is a local 
adaptation of Pielou's normalized diversity index \code{\link{NShannon}}.
}
\examples{
x <- segdata@data[ ,1:2]
HLoc(x) 
}
\references{
Theil H. (1972) \emph{Statistical Decomposition Analysis}. 
North-Holland, Amsterdam
}
\seealso{
Other local indices \code{\link{LQ}}
\code{\link{LShannon}}, \code{\link{LSimpson}}
}

