% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SegFunctions.R
\name{ACE}
\alias{ACE}
\title{A function to compute Massey Absolute Centralisation Index (ACE)}
\usage{
ACE(x, a = NULL, dc = NULL, center = 1, 
spatobj = NULL, folder = NULL, shape = NULL)
}
\arguments{
\item{x}{- an object of class matrix (or which can be coerced to that class), 
where each column represents the distribution of a population group, within 
spatial units. The number of columns should be greater than 1 (at least 2 
population groups are required). You should not include a column with total 
population in each unit, because this will be interpreted as a group.}

\item{a}{- a numeric vector containing the areas of spatial units}

\item{dc}{- a numeric vector containing the distances between spatial units 
centroids and the central spatial unit}

\item{center}{- a numeric value giving the number of the spatial unit that 
represents the centre in the table}

\item{spatobj}{- a spatial object (SpatialPolygonsDataFrame) containing 
geographic information}

\item{folder}{- a character vector with the folder (directory) 
name indicating where the shapefile with the geographic information 
is located.}

\item{shape}{- a character vector with the name of the shapefile 
(without the .shp extension) which contains the geographic information}
}
\value{
a numeric vector containing asolute centralisation index value for 
each population group
}
\description{
The absolute centralization index measures a group
spatial distribution compared to the distribution of land area 
around the city centre. The function can be used in two ways: to provide 
an area vector and a vector containing the distances between spatial units 
centroids and  the central spatial unit or a external geographic information 
source (spatial object or shape file).
}
\examples{
x <- segdata@data[ ,1:2]
ar<-area(segdata)
distc<- distcenter(segdata, center = 45)
foldername <- system.file('extdata', package = 'OasisR')
shapename <- 'segdata'

ACE(x, a = ar, dc=distc) 

ACE(x, spatobj = segdata, center = 45) 

ACE(x, folder = foldername, shape = shapename, center = 45) 

}
\references{
Massey D. S. and Denton N. A. (1988) \emph{
The dimensions of residential segregation}. 
Social Forces 67(2),  pp. 281-315.
}
\seealso{
Duncan's Absolute Centralisation Index: \code{\link{ACEDuncan}}

Relative Centralisation Index: \code{\link{RCE}}
}

