% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/roxygen.R
\name{loglik_cpp}
\alias{loglik_cpp}
\title{Interface to C++ Log-Likelihood Implementation}
\usage{
loglik_cpp(theta, W, X, Y, weights, nReg, nThreads)
}
\arguments{
\item{theta}{named coefficient vector as parsed from formula interface \code{\link{opsr}}.}

\item{W}{list of matrices with explanatory variables for selection process for each regime.}

\item{X}{list of matrices with expalanatory varialbes for outcome process for each regime.}

\item{Y}{list of vectors with continuous outcomes for each regime.}

\item{weights}{vector of weights. See also \code{\link{opsr}}.}

\item{nReg}{integer number of regimes.}

\item{nThreads}{number of threads to be used by \code{OpenMP} (should be max. \code{nReg}).}
}
\value{
Numeric vector of (weighted) log-likelihood contributions.
}
\description{
This is the main computation engine wrapped by \code{\link{opsr.fit}}.
}
\seealso{
\code{\link{opsr.fit}}, \code{\link{loglik_R}}
}
