% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/texreg.R
\name{extract,opsr-method}
\alias{extract,opsr-method}
\alias{extract.opsr}
\title{Extract Method for OPSR Model Fits}
\usage{
\S4method{extract}{opsr}(
  model,
  beside = FALSE,
  include.structural = TRUE,
  include.selection = TRUE,
  include.outcome = TRUE,
  include.pseudoR2 = FALSE,
  include.R2 = FALSE,
  ...
)
}
\arguments{
\item{model}{an object of class \code{"opsr"}.}

\item{beside}{if \code{TRUE}, prints structural, selection and outcome coefficients side-by-side.}

\item{include.structural}{whether or not structural coefficients should be printed.}

\item{include.selection}{whether or not selection coefficients should be printed.}

\item{include.outcome}{whether or not outcome coefficients should be printed.}

\item{include.pseudoR2}{whether or not the pseudo R2 statistic for the selection
component should be printed. See also the 'Details' section.}

\item{include.R2}{whether or not the R2 statistic for the outcome component
should be printed.}

\item{...}{additional arguments passed to \code{\link{summary.opsr}}.}
}
\value{
A \code{texreg-class} object representing the statistical model.
}
\description{
This is the main method called when using functions from the \code{texreg-package}.
}
\details{
The \code{extract} method is called internally. Higher-level functions from the
\code{texreg-package} pass arguments via \code{...} to \code{extract}.

\code{include.pseudoR2} reports both the "equally likely" (EL) and "market share" (MS)
pseudo R2.
}
\examples{
sim_dat <- opsr_simulate()
dat <- sim_dat$data
model <- ys | yo ~ xs1 + xs2 | xo1 + xo2
fit <- opsr(model, dat)
fit_null <- opsr_null_model(fit)
fit_intercept <- update(fit, ~ . | 1)

texreg::screenreg(fit)
texreg::screenreg(fit, beside = TRUE)
texreg::screenreg(fit, beside = TRUE, include.pseudoR2 = TRUE, include.R2 = TRUE)
texreg::screenreg(list(fit_null, fit_intercept, fit))
}
\seealso{
\code{texreg-package}, \code{\link[texreg:texreg]{texreg::texreg}}, \code{\link[texreg:screenreg]{texreg::screenreg}} and related functions.
}
