% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KowaAP7000Client.r
\name{opiSetup_for_KowaAP7000}
\alias{opiSetup_for_KowaAP7000}
\title{opiSetBackground}
\usage{
opiSetup_for_KowaAP7000(lum = NA, color = NA, fixation = NA)
}
\arguments{
\item{lum}{Must be 10 for a white background and 100 for a yellow.}

\item{color}{One of \code{.opi_env$KowaAP7000$BACKGROUND_WHITE} or \code{.opi_env$KowaAP7000$BACKGROUND_YELLOW}.}

\item{fixation}{One of
* \code{.opi_env$KowaAP7000$FIX_CENTER}, fixation marker in the centre.
* \code{.opi_env$KowaAP7000$FIX_CENTRE}, fixation marker in the centre.
* \code{.opi_env$KowaAP7000$FIX_AUX},    fixation marker is ???.
* \code{.opi_env$KowaAP7000$FIX_MACULA}, fixation marker is a circle(?).
* \code{.opi_env$KowaAP7000$FIX_AUX_LEFT}, fixation marker is as for AUX but only lower left.}
}
\value{
Always returns \code{list(err = NULL)}
}
\description{
Implementation of opiSetup for the Kowa AP7000 machine.

This is for internal use only. Use \code{\link[=opiSetup]{opiSetup()}} with these Arguments.
}
\details{
If \code{lum} is 10 and \code{color} is not set, then
\code{.opi_env$KowaAP7000$BACKGROUND_WHITE} is assumed.

If \code{lum} is 100 and \code{color} is not set,
then \code{.opi_env$KowaAP7000$BACKGROUND_YELLOW} is assumed.

If both \code{lum} and \code{color} is set, then \code{lum} is ignored
(a warning will be generated

If \code{lum} is incompatible with \code{color}).
}
