% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RlaPlots.r
\name{RlaPlots}
\alias{RlaPlots}
\title{RLA plots}
\usage{
RlaPlots(featuredata, groupdata, minoutlier = 0.5, type = c("ag", "wg"),
  saveplot = FALSE, plotname = "RLAPlot", savetype = c("png", "bmp",
  "jpeg", "tiff", "pdf"), interactiveplot = TRUE, interactiveonly = TRUE,
  saveinteractiveplot = FALSE, interactivesavename = "interactiveRlaPlot",
  cols = NULL, cex.axis = 0.8, las = 2, ylim = c(-2, 2), oma = c(7, 4,
  4, 2) + 0.1, xlabel = "Samples", showlegend = TRUE, ...)
}
\arguments{
\item{featuredata}{featuredata A data frame in the featuredata format. 
 This is a dataframe with metabolites in columns and samples in rows.
Unique sample names should be provided as row names.
See NormalizeMets Vignette for details.}

\item{groupdata}{A data frame or a vector with group names.}

\item{minoutlier}{A number indicating which samples names to show, samples
names will only be shown for samples with a median reading greater than the
number entered.}

\item{type}{A character string indicating whether within group ("\code{wg}")
or across group ("\code{ag}") RLA plots need to be plotted.}

\item{saveplot}{A logical indication whether to save the plot produced.}

\item{plotname}{Name of the output file if the file is to be saved.}

\item{savetype}{The required format for the plot to be saved in. Threre is a
choice of \code{"png","bmp","jpeg","tiff","pdf"} type files.}

\item{interactiveplot}{A boolean indicator whether to make an interactive plot.}

\item{interactiveonly}{A boolean indicating whether only an interactive plot should be returned.}

\item{saveinteractiveplot}{A boolean indicating whether to save the interactive plot as an html file.}

\item{interactivesavename}{A character string to be used as the filename for saving the interactive plot.}

\item{cols}{A character string with colours to be used for the box plots.}

\item{cex.axis}{The magnification to be used for \emph{x}- and
\emph{y}-labels relative to the current setting of cex.}

\item{las}{A numeric in 0, 1, 2, 3 denoting the style of axis labels.  See
\code{\link[graphics]{par}}.}

\item{ylim}{A vector containing \emph{y}-axis limits.}

\item{oma}{A vector giving the size of the outer margins.}

\item{xlabel}{Label for the x-axis}

\item{showlegend}{A logical indicator whether to display a legend for the plot.}

\item{...}{Other graphical parameters. See \code{\link[graphics]{par}}.}
}
\description{
Produces within group and across group relative log abundance plots to
visualise a metabolomics data matrix. See De Livera \emph{et al}. 2012, 2013, and 2015 for details.
}
\examples{

    data(mixdata)
    
    RlaPlots(mixdata$featuredata, mixdata$sampledata[,1], 
    ylim = c(-2, 2), cols = c("green","purple"),cex.axis = 0.8)
    
}
\references{
De Livera, A. M., Dias, D. A., De Souza, D., Rupasinghe, T.,
Pyke, J., Tull, D., Roessner, U., McConville, M., Speed, T. P. (2012a)
Normalising and integrating metabolomics data. \emph{Analytical Chemistry}
84(24): 10768-10776.

De Livera, A. M., Olshansky M., and Speed, T.P. 2013. Statistical 
Analysis of Metabolomics Data. Methods in Molecular Biology (Clifton, N.J.) 
1055 (Jan): 291-307.

De Livera, A. M,. Aho-Sysi M., Laurent J., Gagnon-Bartch J., 
Sandra, C, Simpson, J.A., and Speed, T. P. 2015. Statistical Methods 
for Handling Unwanted Variation in Metabolomics Data. Analytical Chemistry 87 (7). 
American Chemical Society: 3606-3615.
}
\author{
Alysha M De Livera, Gavriel Olshansky
}
