% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ComparePvalHist.R
\name{ComparePvalHist}
\alias{ComparePvalHist}
\title{p-value Histogram}
\usage{
ComparePvalHist(lpvals = NULL, normmeth = NULL, saveplot = FALSE,
  savetype = c("png", "bmp", "jpeg", "tiff", "pdf"), xlab = "P-Values",
  ylab = "Frequency", ylim = NULL, xlim = c(0, 1), col = "grey",
  plotname = "PvalHistComp", ...)
}
\arguments{
\item{lpvals}{A list with vectors of p-values}

\item{normmeth}{A vector with the normalization method used corresponding in order to the 
data supplied to be displayed on the plot.}

\item{saveplot}{A logical indication whether to save the plot produced.}

\item{savetype}{The required format for the plot to be saved in. Threre is a
choice of \code{"png","bmp","jpeg","tiff","pdf"} type files.}

\item{xlab}{x-axis label}

\item{ylab}{y-axis label}

\item{ylim}{y-axis limit}

\item{xlim}{x-axis limit}

\item{col}{a colour to be used to fill the bars. The default of NULL yields unfilled bars.}

\item{plotname}{Name of the output file if the file is to be saved. This is
the general name for all the graphs and the specific type prefix will be
added automatically.}

\item{...}{Other parameters for the \code{\link[graphics]{hist}} function.}
}
\description{
Make a p-value Histogram of results
}
\examples{
data("alldata_eg")
featuredata_eg<-alldata_eg$featuredata
dataview(featuredata_eg)
sampledata_eg<-alldata_eg$sampledata
dataview(sampledata_eg)
metabolitedata_eg<-alldata_eg$metabolitedata
dataview(metabolitedata_eg)

logdata <- LogTransform(featuredata_eg)
dataview(logdata$featuredata)
imp <-  MissingValues(logdata$featuredata,sampledata_eg,metabolitedata_eg,
                     feature.cutof=0.8, sample.cutoff=0.8, method="knn")
dataview(imp$featuredata)

#Linear model fit using unadjusted data
factormat<-model.matrix(~gender +Age +bmi, sampledata_eg)
unadjustedFit<-LinearModelFit(featuredata=imp$featuredata,
                             factormat=factormat,
                             ruv2=FALSE)
unadjustedFit

#Linear model fit using `is' normalized data 
Norm_is <-NormQcmets(imp$featuredata, method = "is", 
                    isvec = imp$featuredata[,which(metabolitedata_eg$IS ==1)[1]])
isFit<-LinearModelFit(featuredata=Norm_is$featuredata,
                     factormat=factormat,
                     ruv2=FALSE)
isFit

#Linear model fit with ruv-2 normalization
ruv2Fit<-LinearModelFit(featuredata=imp$featuredata,
                       factormat=factormat,
                       ruv2=TRUE,k=2,
                       qcmets = which(metabolitedata_eg$IS ==1))
ruv2Fit

#Exploring metabolites associated with age
lpvals_age<-list(unadjusted=unadjustedFit$p.value[,"Age"],
                is=isFit$p.value[,"Age"],
                ruv2=ruv2Fit$p.value[,"Age"])

ComparePvalHist(lpvals = lpvals_age,ylim=c(0,40), 
     normmeth = c("unadjusted","is","ruv2"))

}
\author{
Alysha M De Livera, Gavriel Olshansky
}
