% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LogTransform.R
\name{LogTransform}
\alias{LogTransform}
\title{Log transformation}
\usage{
LogTransform(featuredata, base = exp(1), saveoutput = FALSE,
  outputname = "log.results", zerotona = FALSE)
}
\arguments{
\item{featuredata}{featuredata A data frame in the featuredata format. 
 This is a dataframe with metabolites in columns and samples in rows.
Unique sample names should be provided as row names.
See NormalizeMets Vignette for details.}

\item{base}{The base with respect to which logarithms are computed. The
default computes the natural logarithm.}

\item{saveoutput}{A logical indicating whether the output should be saved as
a .csv file.}

\item{outputname}{The name of the output file if the output has to be saved.}

\item{zerotona}{A logical indicating whether any zeros should be converted to missing prior to
log transforming. By default, this is set to FALSE.}
}
\value{
The result is an object of class
\code{\link[NormalizeMets:alldata]{alldata}}.
}
\description{
Log transform a metabolomics feature data matrix.
}
\examples{

    data(alldata_eg)
    lg <- LogTransform(alldata_eg$featuredata)
    dataview(lg$featuredata)

}
\author{
Alysha M De Livera
}
