% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/NeuralNetTools_utils.R
\name{neuralskips}
\alias{neuralskips}
\alias{neuralskips.nnet}
\title{Get weights for the skip layer in a neural network}
\usage{
neuralskips(mod_in, ...)

\method{neuralskips}{nnet}(mod_in, ...)
}
\arguments{
\item{mod_in}{input object for which an organized model list is desired.}

\item{...}{arguments passed to other methods}
}
\value{
return a numeric vector in sequential order of the weights for the direct connection between input and output layers
}
\description{
Get weights for the skip layer in a neural network, only valid for networks created using \code{skip = TRUE} with the \code{\link[nnet]{nnet}} function.
}
\details{
This function is similar to \code{\link{neuralweights}} except only the skip layer weights are returned.
}
\examples{
data(neuraldat)
set.seed(123)

## using nnet

library(nnet)

mod <- nnet(Y1 ~ X1 + X2 + X3, data = neuraldat, size = 5, linout = TRUE,
 skip = TRUE)

neuralskips(mod)
}

