% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootgen.plot.R
\name{bootgen.plot}
\alias{bootgen.plot}
\title{Bootstrapped Network Generalization Plots}
\usage{
bootgen.plot(object, bootmat = FALSE, breaks = 20)
}
\arguments{
\item{object}{An output from the \link[NetworkToolbox]{bootgen} function}

\item{bootmat}{Should the bootstrap generalization matrix be included?
Defaults to FALSE.
Set to TRUE to plot the original and bootmat networks' reliablities}

\item{breaks}{If bootmat = TRUE, then reliability comparison histogram is produced.
The breaks may not appear as desired, so the researcher can adjust as needed.
Defaults to 20 (try 10 if 20 isn't equivalent breaks)}
}
\value{
Returns the following plots:

\item{orignet}{A reliability matrix for the original network
("Original Network Correlation Reliabilities"
upper triangle = network reliabilites from the filtered network,
lower triangle = full, unfiltered matrix reliablities)}

\item{orignet retained}{A plot of retained correlations on their reliability
("Original Network Correlation Strength on Reliability")}

\item{bootmat}{A reliability matrix for the bootgen network
("bootgen Network Correlation Reliabilities"
upper triangle = network reliabilites from the bootgen filtered network,
lower triangle = full, unfiltered matrix reliablities)}

\item{bootmat retained}{A plot of retained correlations on their reliability
("bootgen Network Correlation Strength on Reliability")}

\item{histogram}{A frequency of the reliability of edges
in both the original and bootgen network}
}
\description{
Generates reliability plots from the \link[NetworkToolbox]{bootgen} function
}
\examples{
\dontrun{
bootTMFG <- bootgen(neoOpen)

bootPlot <- bootPlot(bootTMFG)
}
}
\references{
Wei, T. & Simko, V.(2017).
R package "corrplot": Visualization of a correlation matrix (Version 0.84).
Available from \url{https://github.com/taiyun/corrplot}
}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
