% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NetworkToolbox--master.R
\name{hybrid}
\alias{hybrid}
\title{Hybrid Centrality}
\usage{
hybrid(A, BC = c("standard", "random", "average"), beta)
}
\arguments{
\item{A}{An adjacency matrix of network data}

\item{BC}{How should the betweenness centrality be computed?
Defaults to "standard".
Set to "random" for rspbc.
Set to "average" for the average of "standard" and "random"}

\item{beta}{Beta parameter to be passed to the \emph{rspbc} function}
}
\value{
A vector of hybrid centrality values for each node in the network
(higher values are more central, lower values are more peripheral)
}
\description{
Computes hybrid centrality of each node in a network
}
\examples{
A<-TMFG(neoOpen)$A

HC<-hybrid(A)
}
\references{
Pozzi, F., Di Matteo, T., & Aste, T. (2013).
Spread of risk across financial markets: Better to invest in the peripheries. 
\emph{Scientific Reports}, \emph{3}(1655), 1-7.
}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
