% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NetworkToolbox--master.R
\name{centlist}
\alias{centlist}
\title{List of Centrality Measures}
\usage{
centlist(A, weighted = TRUE)
}
\arguments{
\item{A}{An adjacency matrix of network data}

\item{weighted}{Is the network weighted? Defaults to TRUE. Set to FALSE for unweighted list of centrality measures}
}
\value{
Returns a list of betweenness, closeness, degree (weighted = strength), eigenvector, and leverage centralities
}
\description{
Computes centrality measures of the network
}
\examples{
A<-TMFG(hex)$A

weighted_centralitylist<-centlist(A)

unweighted_centralitylist<-centlist(A,weighted=FALSE)
}
\references{
Rubinov, M., & Sporns, O. (2010). 
Complex network measures of brain connectivity: Uses and interpretations. 
\emph{Neuroimage}, \emph{52}(3), 1059-1069.
}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
