% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/agentset-functions.R
\name{NLset}
\alias{NLset}
\alias{set}
\alias{NLset,missing,agentMatrix,agentMatrix,character-method}
\alias{NLset,worldMatrix,missing,matrix,missing-method}
\alias{NLset,worldArray,missing,matrix,character-method}
\title{Set an \code{agents} variable}
\usage{
NLset(world, turtles, agents, var, val)

\S4method{NLset}{missing,agentMatrix,agentMatrix,character}(turtles, agents, var, val)

\S4method{NLset}{worldMatrix,missing,matrix,missing}(world, agents, val)

\S4method{NLset}{worldArray,missing,matrix,character}(world, agents, var, val)
}
\arguments{
\item{world}{\code{WorldMatrix} or \code{worldArray} object.}

\item{turtles}{\code{AgentMatrix} object representing the moving \code{agents}.}

\item{agents}{Matrix (\code{ncol} = 2) with the first column \code{pxcor} and the second
              column \code{pycor} representing the \code{patches} coordinates, or

              \code{AgentMatrix} object representing the moving \code{agents}.}

\item{var}{Character. Vector of the names of the selected \code{agents} variables.
If \code{agents} are \code{patches} and the \code{world} is a
\code{worldMatrix} object, \code{var} must not be provided. If
\code{agents} are \code{patches} and the \code{world} is a
\code{worldArray} object, \code{var} is the name of the layers to
use to define the \code{patches}
values. If \code{agents} are \code{turtles}, \code{var} is some of
the \code{turtles}' variable and can be any of the variables created
when \code{turtles} were created,
as well as any variable created with \code{turtlesOwn()}.}

\item{val}{Numeric or character. Vector of length 1 or length \code{NLcount(agents)}
           if \code{length(var) == 1}, or

           Matrix or \code{Dataframe} (\code{ncol} = \code{length(var)}, \code{nrow} = \code{NLcount(agents)}).
           Columns must be in the same order as \code{var}.}
}
\value{
\code{WorldMatrix} or \code{worldArray} object with the values \code{val} assigned to the \code{patches}
        variables \code{var}
        for the \code{agents}, or

        \code{AgentMatrix} representing the \code{turtles} with
        the values \code{val} assigned to the variables \code{var} for the \code{agents}.
}
\description{
Assign values to the \code{agents} for the selected variables.
}
\details{
If \code{agents} are \code{patches}, \code{world} must be provided and \code{turtles}
         must not be provided. If \code{agents} are \code{turtles}, \code{turtles} must be
         provided and \code{world} must not be provided.
}
\examples{
w1 <- createWorld(minPxcor = 0, maxPxcor = 4, minPycor = 0, maxPycor = 4)
w1 <- NLset(world = w1, agents = patches(w1), val = 1)
# Set the patch[0,4] to 0
w1 <- NLset(world = w1, agents = patch(w1, 0, 4), val = 0)
of(world = w1, agents = patches(w1))

t1 <- createTurtles(n = 3, world = w1, heading = 0)
# Set the heading of turtle 0 to 180
t2 <- NLset(turtles = t1, agents = turtle(t1, who = 0), var = "heading", val = 180)
of(agents = t2, var = "heading") # c(180, 0, 0)


}
\references{
Wilensky, U. 1999. NetLogo. \url{http://ccl.northwestern.edu/netlogo/}.
            Center for Connected Learning and Computer-Based Modeling,
            Northwestern University. Evanston, IL.
}
\seealso{
\url{https://ccl.northwestern.edu/netlogo/docs/dictionary.html#set}
}
\author{
Sarah Bauduin
}
