% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/turtle-functions.R
\docType{methods}
\name{turtlesOwn}
\alias{turtlesOwn}
\alias{turtlesOwn,agentMatrix,character,missing-method}
\alias{turtlesOwn,agentMatrix,character,ANY-method}
\title{New \code{turtles} variable}
\usage{
turtlesOwn(turtles, tVar, tVal)

\S4method{turtlesOwn}{agentMatrix,character,missing}(turtles, tVar)

\S4method{turtlesOwn}{agentMatrix,character,ANY}(turtles, tVar, tVal)
}
\arguments{
\item{turtles}{\code{AgentMatrix} object representing the moving \code{agents}.}

\item{tVar}{Character. the name of the \code{turtles} variable to create.}

\item{tVal}{Vector representing the values of \code{tVar}.
Must be of length 1 or of length \code{turtles}.
If missing, \code{NA} is given.}
}
\value{
\code{AgentMatrix} representing the \code{turtles} with the new
        variable \code{tVar} added.
}
\description{
Create a new variable for the \code{turtles}.
}
\examples{
t1 <- createTurtles(n = 5, coords = cbind(xcor = 0, ycor = 0))
t1 <- turtlesOwn(turtles = t1, tVar = "sex", tVal = c("F", "F", "F", "M", "M"))


}
\references{
Wilensky, U. 1999. NetLogo. http://ccl.northwestern.edu/netlogo/.
            Center for Connected Learning and Computer-Based Modeling,
            Northwestern University. Evanston, IL.
}
\seealso{
\url{https://ccl.northwestern.edu/netlogo/docs/dictionary.html#turtles-own}
}
\author{
Sarah Bauduin
}
