% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/agentset-functions.R
\docType{methods}
\name{nOf}
\alias{nOf}
\alias{nOf,matrix,numeric-method}
\title{N random \code{agents}}
\usage{
nOf(agents, n)

\S4method{nOf}{matrix,numeric}(agents, n)
}
\arguments{
\item{agents}{Matrix (\code{ncol} = 2) with the first column \code{pxcor} and the second
              column \code{pycor} representing the \code{patches} coordinates, or

              Matrix (\code{ncol} = 3) with the first column "\code{pxcor} and the second
              column \code{pycor} representing the \code{patches} coordinates and the
              third column \code{id}, or

              \code{AgentMatrix} object representing the moving \code{agents}, or

              Matrix (\code{ncol} = 2) with the first column \code{whoTurtles} and the
              second column \code{id}.}

\item{n}{Integer. Number of \code{patches} or \code{turtles} to select from \code{agents}.}
}
\value{
Matrix (\code{ncol} = 2, \code{nrow} = \code{n}) with the first column \code{pxcor}
        and the second  column \code{pycor} representing the coordinates of the
        selected patches from \code{agents}, or

        Matrix (\code{ncol} = 2) with the first column \code{pxcor}
        and the second  column \code{pycor} representing the coordinates of the
        selected \code{patches} from \code{agents}, \code{n} per individual "id", or

        \code{AgentMatrix} (\code{nrow} = \code{n}) representing the \code{turtles}
        selected from \code{agents},

        Integer. Vector of \code{who} numbers for the selected \code{turtles} from
        \code{agents}, \code{n} per individual "id".
}
\description{
Report \code{n} \code{patches} or \code{turtles} randomly selected among \code{agents}.
}
\details{
\code{n} must be less or equal the number of \code{patches}
         or \code{turtles} in \code{agents}.

         If \code{agents} is a matrix with \code{ncol} = 3, the selection of \code{n}
         random \code{patches} is done per individual "id". The order of the \code{patches}
         coordinates returned follow the order of "id".
         If \code{agents} is a matrix (\code{ncol} = 2) with columns \code{whoTurtles} and
         \code{id}, the selection of \code{n} random \code{turtles} (defined by their \code{whoTurtles})
         is done per individual "id". The order of the \code{who} numbers returned
         follow the order of "id".
}
\examples{
# Patches
w1 <- createWorld(minPxcor = 0, maxPxcor = 4, minPycor = 0, maxPycor = 4)
pSelect <- nOf(agents = patches(w1), n = 5)

# Turtles
t1 <- createTurtles(n = 10, coords = randomXYcor(w1, n = 10))
tSelect <- nOf(agents = t1, n = 2)


}
\references{
Wilensky, U. 1999. NetLogo. \url{http://ccl.northwestern.edu/netlogo/}.
            Center for Connected Learning and Computer-Based Modeling,
            Northwestern University. Evanston, IL.
}
\seealso{
\url{https://ccl.northwestern.edu/netlogo/docs/dictionary.html#n-of}
}
\author{
Sarah Bauduin
}
