% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hello.R
\name{MKF.Full.RB}
\alias{MKF.Full.RB}
\title{Full Information Propagation Step under Mixture Kalman Filter}
\usage{
MKF.Full.RB(
  MKFstep.Full.RB,
  nobs,
  yy,
  mm,
  par,
  II.init,
  mu.init,
  SS.init,
  xdim,
  ydim,
  resample.sch
)
}
\arguments{
\item{MKFstep.Full.RB}{a function that performs one step propagation under mixture Kalman filter, with full information proposal distribution.
Its input includes \code{(mm,II,mu,SS,logww,yyy,par,xdim,ydim)}, where
\code{II}, \code{mu}, and \code{SS} are the indicators and its corresponding mean and variance matrix of the Kalman filter components in the last iterations.
\code{logww} is the log weight of the last iteration. \code{yyy} is the
observation at current time step. It should return the Rao-Blackwellization estimation of the mean and variance.}

\item{nobs}{the number of observations \code{T}.}

\item{yy}{the observations with \code{T} columns and \code{ydim} rows.}

\item{mm}{the Monte Carlo sample size \code{m}.}

\item{par}{a list of parameter values to pass to \code{Sstep}.}

\item{II.init}{the initial indicators.}

\item{mu.init}{the initial mean.}

\item{SS.init}{the initial variance.}

\item{xdim}{the dimension of the state varible \code{x_t}.}

\item{ydim}{the dimension of the observation \code{y_t}.}

\item{resample.sch}{a binary vector of length \code{nobs}, reflecting the resampling schedule. resample.sch[i]= 1 indicating resample should be carried out at step \code{i}.}
}
\value{
The function returns a list with components:
\item{xhat}{the fitted value.}
\item{xhatRB}{the fitted value using Rao-Blackwellization.}
\item{Iphat}{the estimated indicators.}
\item{IphatRB}{the estimated indicators using Rao-Blackwellization.}
}
\description{
This function implements the full information propagation step under mixture Kalman filter with full information proposal distribution and Rao-Blackwellization, no delay.
}
\references{
Tsay, R. and Chen, R. (2018). Nonlinear Time Series Analysis. John Wiley & Sons, New Jersey.
}
