% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hello.R
\name{SMC.Full.RB}
\alias{SMC.Full.RB}
\title{Generic Sequential Monte Carlo Using Full Information Proposal Distribution and Rao-Blackwellization}
\usage{
SMC.Full.RB(SISstep.Full.RB, nobs, yy, mm, par, xx.init, xdim, ydim,
  resample.sch)
}
\arguments{
\item{SISstep.Full.RB}{a function that performs one step propagation using a proposal distribution.
Its input includes \code{(mm,xx,logww,yyy,par,xdim,ydim,resample)}, where
\code{xx} and \code{logww} are the last iteration samples and log weight. \code{yyy} is the
observation at current time step. It should return \code{xx} (the samples xt) and
\code{logww} (their corresponding log weight), \code{resample} is a binary value for resampling.}

\item{nobs}{the number of observations \code{T}.}

\item{yy}{the observations with \code{T} columns and \code{ydim} rows.}

\item{mm}{the Monte Carlo sample size \code{m}.}

\item{par}{a list of parameter values to pass to \code{Sstep}.}

\item{xx.init}{the initial samples of \code{x_0}.}

\item{xdim}{the dimension of the state varible \code{x_t}.}

\item{ydim}{the dimension of the observation \code{y_t}.}

\item{resample.sch}{a binary vector of length \code{nobs}, reflecting the resampling schedule. resample.sch[i]= 1 indicating resample should be carried out at step \code{i}.}
}
\value{
The function returns a list with the following components:
\item{xhat}{the fitted values.}
\item{xhatRB}{the fitted values using Rao-Blackwellization.}
}
\description{
Generic sequential Monte Carlo using full information proposal distribution with Rao-Blackwellization estimate, and delay is 0.
}
\references{
Tsay, R. and Chen, R. (2018). Nonlinear Time Series Analysis. John Wiley & Sons, New Jersey.
}
