\name{SimulateTypeC}
\alias{SimulateTypeC}
\title{Simulation of the Generalized Thomas Model of Type C}
\description{
  Simulation of the Generalized Thomas Model of Type C.
}
\usage{
  SimulateTypeC(seeds, pa1, pa2, Ty=1, pmax=100, omax=3000, plot=TRUE)
}
\arguments{
  \item{seeds}{the three positive integer variables, which are initial seeds for a sequence of uniform random numbers.}
  \item{pa1}{the parameter values \eqn{(\mu_1, \nu_1, \sigma_1)}{(mu_1, nu_1, sigma_1)} for the random variable Poisson.}
  \item{pa2}{the parameter values \eqn{(\mu_2, \nu_2, \sigma_2)}{(mu_2, nu_2, sigma_2)} for the random variable Poisson.}
  \item{Ty}{the variable for the standardized coordinates of points in the rectangular region \eqn{[0,1] \times [0,T_y]}{[0,1]*[0,Ty]} without loss of generality except for the scaling.}
  \item{pmax}{maximum number of parent points.}
  \item{omax}{maximum number of offspring points.}
  \item{plot}{logical. If TRUE (default) simulated parent points and offspring points are plotted.}
}
\details{
  Consider the two type of the Thomas model with parameters \eqn{(\mu_1, \nu_1, \sigma_1)}{(mu_1, nu_1, sigma_1)} and \eqn{(\mu_2, \nu_2, \sigma_2)}{(mu_2, nu_2, sigma_2)}.
  Parents' configuration and numbers of the offspring cluster sizes are generated by the two types of uniformly 
 distributed parents \eqn{(x_i^k, x_i^k)} with \eqn{i=1,2,...,Poisson(\mu_k)}{i=1,2,...,Poisson(mu_k)} for k=1,2, respectively.

  Then, using series of different uniform random numbers \eqn{\{ U \}}{{U}} for different \eqn{i} and \eqn{j}, the offspring coordinates 
\eqn{(x_j^{k,i}, y_j^{k,i}), j=1,2,...,Poisson(\nu_k)}{(x_j^{k,i}, y_j^{k,i}), j=1,2,...,Poisson(nu_k)} of the parents \eqn{(k,i)} with \eqn{k=1,2} is given by

  \deqn{x_j^{k,i} = x_i^k + r_k \cos(2 \pi U),}{%
        x_j^{k,i} = x_i^k + r_k cos(2 \pi U),}
  \deqn{y_j^{k,i} = y_i^k + r_k \sin(2 \pi U),}{%
        y_j^{k,i} = y_i^k + r_k sin(2 \pi U),}

  where 

  \deqn{r_k = \sigma_k \sqrt{-2 \log(1-U_k)}, \; k=1,2,}{%
        r_k = sigma_k sqrt{-2log(1-U_k)}, k=1,2, }

  with different random numbers \eqn{\{ U_k, U \}}{{U_k, U}} for different \eqn{k,i} and \eqn{j}.
}
\value{
  \item{n.parents1}{the number of simulated parent points with \eqn{\mu_1}{mu_1}.}
  \item{parents1}{the coordinates of simulated parent points with \eqn{\mu_1}{mu_1}.}
  \item{n.offspring1}{the total number of simulated offspring points with \eqn{\mu_1}{mu_1}.}
  \item{offspring1}{the coordinates of simulated offspring points with \eqn{\mu_1}{mu_1}.}
  \item{n.parents2}{the number of simulated parent points with \eqn{\mu_2}{mu_2}.}
  \item{parents2}{the coordinates of simulated parent points \eqn{\mu_2}{mu_2}.}
  \item{n.offspring2}{the total number of simulated offspring points \eqn{\mu_2}{mu_2}.}
  \item{offspring2}{the coordinates of simulated offspring points \eqn{\mu_2}{mu_2}.}
}
\references{
  U. Tanaka, Y. Ogata and K. Katsura,
  Simulation and estimation of the Neyman-Scott type spatial cluster models, \emph{Computer Science Monographs} \bold{No.34}, 2008, 1-44.
  The Institute of Statistical Mathematics.
}
\examples{
  seeds <- c(822, 913, 905)
  mu1 <- 5;  nu1 <- 30;  sig1 <- 0.01 
  mu2 <- 9;  nu2 <- 150;  sig2 <- 0.05
  SimulateTypeC( seeds, c(mu1,nu1,sig1), c(mu2,nu2,sig2), pmax=200, omax=300 )
}

\keyword{spatial}
