% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NRejections.R
\name{dataset_result}
\alias{dataset_result}
\title{Fit all models for a single dataset}
\usage{
dataset_result(d, X, C = NA, Ys, alpha = 0.05, center.stats = TRUE,
  bhat.orig = NA)
}
\arguments{
\item{d}{Dataframe}

\item{X}{Single quoted name of covariate of interest}

\item{C}{Vector of quoted covariate names}

\item{Ys}{W-vector of quoted outcome names}

\item{alpha}{Alpha level for individual tests}

\item{center.stats}{Should test statistics be centered by original-sample estimates to enforce
global null?}

\item{bhat.orig}{Estimated coefficients for covariate of interest in original sample (W-vector).
Can be left NA for non-centered stats.}
}
\value{
Returns a list containing the number of observed rejections (\code{rej}), 
the coefficient estimates of interest for each outcome model (\code{bhats}), their t-values
(\code{tvals}), their uncorrected p-values at level \code{alpha} (\code{pvals}), and a matrix of
residuals from each model (\code{resid}). The latter is used for residual resampling under the 
global null.
}
\description{
The user does not need to call this function. For a single dataset, fits separate OLS models for W outcomes with or without centering the test statistics
to enforce the global null.
}
\examples{
samp.res = dataset_result( X = "complaints",
           C = c("privileges", "learning"),
           Ys = c("rating", "raises"),
           d = attitude,
           center.stats = FALSE,
           bhat.orig = NA,  # bhat.orig is a single value now for just the correct Y
           alpha = 0.05 )
}
