% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Partial_Moments.R
\name{NNS.PDF}
\alias{NNS.PDF}
\title{NNS PDF}
\usage{
NNS.PDF(variable, degree = 1, target = NULL, bins = NULL,
  plot = TRUE)
}
\arguments{
\item{variable}{a numeric vector.}

\item{degree}{integer; \code{(degree = 0)} is frequency, \code{(degree = 1)} (default) is area.}

\item{target}{a numeric range of values [a,b] where a < b.  \code{NULL} (default) uses the \code{variable} observations.}

\item{bins}{numeric; \code{NULL} (default) Selects number of observations as default bins.}

\item{plot}{logical; plots PDF.}
}
\value{
Returns a data.table containing the intervals used and resulting PDF of the variable.
}
\description{
This function generates an empirical PDF using continuous CDFs from \link{LPM.ratio}.
}
\examples{
set.seed(123)
x <- rnorm(100)
NNS.PDF(x)

## Custom target range
NNS.PDF(x, target = c(-5, 5))
}
\references{
Viole, F. and Nawrocki, D. (2013) "Nonlinear Nonparametric Statistics: Using Partial Moments"
\url{http://amzn.com/1490523995}
}
\author{
Fred Viole, OVVO Financial Systems
}
