% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Partial_Moments.R
\name{UPM.ratio}
\alias{UPM.ratio}
\title{Upper Partial Moment RATIO}
\usage{
UPM.ratio(degree, target, variable)
}
\arguments{
\item{degree}{integer; \code{(degree = 0)} is frequency, \code{(degree = 1)} is area.}

\item{target}{numeric; Typically set to mean, but does not have to be. (Vectorized)}

\item{variable}{a numeric vector.}
}
\value{
Standardized UPM of variable
}
\description{
This function generates a standardized univariate upper partial moment for any degree or target.
}
\examples{
set.seed(123)
x<-rnorm(100)
UPM.ratio(0,mean(x),x)

\dontrun{
## Plot Degree 0 (frequency) Joint CDF
x=rnorm(100);y=rnorm(100)
intervals=(max(x,y)-min(x,y))/100
grid.points=seq(min(x,y),max(x,y),intervals)
z=expand.grid(grid.points,grid.points)
plot3d(z[,1],z[,2],LPM.ratio(0,z[,1],x)*LPM.ratio(0,z[,2],y))

## Plot Degree 1 (area) Joint CDF
plot3d(z[,1],z[,2],LPM.ratio(0,z[,1],x)*LPM.ratio(0,z[,2],y))}
}
\references{
Viole, F. and Nawrocki, D. (2013) "Nonlinear Nonparametric Statistics: Using Partial Moments"
\url{http://amzn.com/1490523995}
}
\author{
Fred Viole, OVVO Financial Systems
}
\keyword{CDF}
\keyword{continuous}
\keyword{mean,}
\keyword{moments,}
\keyword{partial}
\keyword{upper}
\keyword{variance,}
