% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NMcreateDoses.R
\name{NMcreateDoses}
\alias{NMcreateDoses}
\title{Easily and flexibly generate dosing records}
\usage{
NMcreateDoses(
  TIME,
  AMT = NULL,
  EVID = 1,
  CMT = 1,
  ADDL = NULL,
  II = NULL,
  RATE = NULL,
  SS = NULL,
  addl = NULL,
  addl.lastonly = TRUE,
  col.id = "ID",
  as.fun
)
}
\arguments{
\item{TIME}{The time of the dosing events. Required.}

\item{AMT}{vector or data.frame with amounts amount. Required.}

\item{EVID}{The event ID to use for doses. Default is to use
EVID=1, but EVID might also be wanted.}

\item{CMT}{Compartment number. Default is to dose into CMT=1. Use
`CMT=NA` to omit in result.}

\item{ADDL}{Number of additional dose events. Must be in
combination with and consistent with II. Notice if of length
1, only applied to last event in each regimen.}

\item{II}{Dosing frequency of additional events specified in
`ADDL`. See `ADDL` too.}

\item{RATE}{Infusion rate. Optional.}

\item{SS}{steady-state flag. Optional.}

\item{addl}{A list of ADDL and II that will be applied to last
dose. This may be prefered if II and ADDL depend on covariates
- see examples. Optional.}

\item{addl.lastonly}{If ADDL and II are of length 1, apply only
to last event of a regimen? The default is `TRUE`.}

\item{col.id}{Default is to denote the dosing regimens by an ID
column. The name of the column can be modified using this
argument. Use `col.id=NA` to omit the column altogether. The
latter may be wanted if repeating the regimen for a number of
subjects after running `NMcreateDoses()`.}

\item{as.fun}{The default is to return data as a data.frame. Pass
a function (say `tibble::as_tibble`) in as.fun to convert to
something else. If data.tables are wanted, use
as.fun="data.table". The default can be configured using
NMdataConf.}
}
\value{
A data.frame with dosing events
}
\description{
Columns will be extended by repeating last value of the column if
needed in order to match length of other columns. Combinations of
different columns can be generated by specifying covariates on the
columns where the regimens differ.
}
\details{
Only TIME and AMT are required. AMT, RATE, SS, II, ADDL,
    CMT are of length 1 or longer. Those not of max length 1 are
    repeated.  If TIME is longer than those, they are extended to
    match length of TIME. All these arguments can be data.frames
    with additional columns that define distinct dosing regimens -
    with distinct subject ids. However, if covariates are applied
    to ADDL+II, see the addl argument and see examples.

Allowed combinations of
    AMT, RATE, SS, II here:
    \url{https://ascpt.onlinelibrary.wiley.com/doi/10.1002/psp4.12404}
}
\examples{
library(data.table)
## Users should not use setDTthreads. This is for CRAN to only use 1 core.
data.table::setDTthreads(1) 
## arguments are expanded - makes loading easy
NMcreateDoses(TIME=c(0,12,24,36),AMT=c(2,1))
## Different doses by covariate
NMcreateDoses(TIME=c(0,12,24),AMT=data.table(AMT=c(2,1,4,2),DOSE=c(1,2)))
## Make Nonmem repeat the last dose. This is a total of 20 dosing events.
## The default, addl.lastonly=TRUE means if ADDL and II are of
## length 1, they only apply to last event.
NMcreateDoses(TIME=c(0,12),AMT=c(2,1),ADDL=9*2,II=12)
dt.amt <- data.table(DOSE=c(100,400))
## multiple dose regimens. 
## Specifying the time points explicitly
dt.amt <- data.table(AMT=c(200,100,800,400)*1000,DOSE=c(100,100,400,400))
doses.md.1 <- NMcreateDoses(TIME=seq(0,by=24,length.out=7),AMT=dt.amt)
doses.md.1$dose <- paste(doses.md.1$DOSE,"mg")
doses.md.1$regimen <- "QD"
doses.md.1
## or using ADDL+II
dt.amt <- data.table(AMT=c(200,100,800,400)*1000,DOSE=c(100,100,400,400))
doses.md.2 <- NMcreateDoses(TIME=c(0,24),AMT=dt.amt,addl=data.table(ADDL=c(0,5),II=c(0,24)))
doses.md.2$dose <- paste(doses.md.2$DOSE,"mg")
doses.md.2$regimen <- "QD"
doses.md.2
## ADDL and II can be wrapped in a data.frame. This allows including covariates
NMcreateDoses(TIME=c(0,12),AMT=c(2,1),addl=data.frame(ADDL=c(NA,9*2),II=c(NA,12),trt=c("A","B")))
}
