% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basic-ctl-manipulation.R
\name{data_path}
\alias{data_path}
\title{Get/set path to dataset}
\usage{
data_path(m, text)
}
\arguments{
\item{m}{An nm object.}

\item{text}{Optional character. Path to input dataset.}
}
\value{
if text is not specified, will return the \code{data_path} name
otherwise will return an nm object with modified \code{data_path} field.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Mainly used to associate a dataset with an nm object.
Requires ctl_contents to already be specified.
}
\examples{

# create example object m1 from package demo files
exdir <- system.file("extdata", "examples", "theopp", package = "NMproject")
m1 <- new_nm(run_id = "m1", 
             based_on = file.path(exdir, "Models", "ADVAN2.mod"),
             data_path = file.path(exdir, "SourceData", "THEOPP.csv"))

data_path(m1) ## display data name
  

}
