% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nlm_randomcluster.R
\name{nlm_randomcluster}
\alias{nlm_randomcluster}
\title{nlm_randomcluster}
\usage{
nlm_randomcluster(nCol, nRow, resolution = 1, neighbourhood = 4, p,
  rescale = TRUE)
}
\arguments{
\item{nCol}{[\code{integer(1)}]\cr
Number of columns in the raster.}

\item{nRow}{[\code{integer(1)}]\cr
Number of rows in the raster.}

\item{resolution}{[\code{numerical(1)}]\cr
Resolution of the raster.}

\item{neighbourhood}{[\code{numerical(1)}]\cr
Clusters are defined using a set of neighbourhood structures,
 4 (Rook's or von Neumann neighbourhood) (default), 8 (Queen's or Moore neighbourhood).}

\item{p}{[\code{numerical(1)}]\cr
The p value defines the proportion of   elements randomly selected to form
clusters.}

\item{rescale}{[\code{logical(1)}]\cr
If \code{TRUE} (default), the values are rescaled between 0-1.}
}
\value{
Raster with random values ranging from 0-1.
}
\description{
Simulates a random cluster nearest-neighbour neutral landscape.
}
\details{
The implemented algorithm has been adopted from Etherington et al. 2014 and is itself an  adaptation of the MRC algorithm by Saura & Martínez-Millán (2000). The algorithm simulates a percolation map, which defines random clusters by running a connected labelling algorithm which detects clusters and gives each a unique ID. The algorithm controls the size and directional bias of the cluster with the proportion of the matrix that is within a cluster and with specifying a specific neighbourhood rule. Each cluster is than given a random value and non-cluster cells are assigned values by performing a nearest neighbour interpolation.
}
\examples{
nlm_randomcluster(nCol = 10, nRow = 10, resolution = 10, neighbourhood = 4, p = 0.4)

}
\references{
Saura, S. & Martínez-Millán, J. (2000) Landscape patterns simulation with a
modified random clusters method. \emph{Landscape Ecology}, 15, 661 – 678.

Etherington TR, Holland EP, O’Sullivan D. 2015. NLMpy: A python software
package for the creation of neutral landscape models within a general
numerical framework. \emph{Methods in Ecology and Evolution} 6:164 – 168.
}
