% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nlm_percolationmaps.R
\name{nlm_percolation}
\alias{nlm_percolation}
\title{nlm_percolation}
\usage{
nlm_percolation(nCol, nRow, resolution = 1, prob = 0.5)
}
\arguments{
\item{nCol}{[\code{numerical(1)}]\cr
Number of columns for the raster.}

\item{nRow}{[\code{numerical(1)}]\cr
Number of rows for the raster.}

\item{resolution}{[\code{numerical(1)}]\cr
Resolution of the raster.}

\item{prob}{[\code{numerical(1)}]\cr
Probability value for setting a cell either to 0 or 1.}
}
\value{
RasterLayer
}
\description{
Create a random percolation neutral landscape model.
}
\details{
The simulation of a random percolation map is accomplished in two steps:

\itemize{
 \item{Initialization: }{ Setup matrix of size (\code{nCol}*\code{nRow})}
 \item{Map generation: }{ For each cell in the matrix a single uniformly
 distributed random number is generated and tested against a probability
 \code{prob}. If the random number is smaller than \code{prob}, the cell is set to
 1 - if it is higher the cell is set to 0.}
}

The proportion of 0 and 1 is thus controlled with the argument \code{prob}.
}
\examples{
nlm_percolation(nCol = 100, nRow = 100, prob=0.5)

}
\references{
1. Gardner RH, O'Neill R V, Turner MG, Dale VH. 1989. Quantifying
scale-dependent effects of animal movement with simple percolation models.
\emph{ Landscape Ecology} 3:217 - 227.

2. Gustafson, E.J. & Parker, G.R. (1992) Relationships between landcover
proportion and indices of landscape spatial pattern. \emph{Landscape Ecology}
, 7, 101 - 110.
}
