% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nlm_fBm.R
\name{nlm_fBm}
\alias{nlm_fBm}
\title{nlm_fBM}
\usage{
nlm_fBm(nCol, nRow, resolution = 1, H = 0.5, user_seed = NULL,
  rescale = TRUE)
}
\arguments{
\item{nCol}{[\code{numerical(1)}]\cr
Number of columns for the raster.}

\item{nRow}{[\code{numerical(1)}]\cr
Number of rows for the raster.}

\item{resolution}{[\code{numerical(1)}]\cr
Resolution of the raster.}

\item{H}{[\code{numerical(1)}]\cr
Hurst coefficient}

\item{user_seed}{[\code{numerical(1)}]\cr
Set Seed for simulation}

\item{rescale}{[\code{numeric(1)}]\cr
If \code{TRUE} (default), the values are rescaled between 0-1.}
}
\value{
RasterLayer
}
\description{
Simulate two-dimensional fractional brownian motion model.
}
\details{
Neutral landscapes are generated using fractional Brownian motion, an extension of Brownian motion in which the amount of correlation between steps is controlled by the Hurst coefficient H. An H of 1 produces a relatively smooth surface while an H of 0 produces a rough, uncorrelated, surface. Implementation of this method is limited to landscapes with extents less than 90 by 90 cells.
}
\examples{
nlm_fBm(nCol = 40, nRow = 40, H = 0.5)

}
