% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bin_sample.R
\name{bin_bam_sample}
\alias{bin_bam_sample}
\alias{nipt_sample}
\title{Load and bin BAM file}
\usage{
bin_bam_sample(bam_filepath, do_sort = FALSE, separate_strands = FALSE,
  custom_name = NULL)
}
\arguments{
\item{bam_filepath}{Character The location and filename on the file system where the bam file is stored}

\item{do_sort}{Boolean Sort the bam file? If the bam is unsorted set to true, 
but the use of pre-sorted bam files is recommended.}

\item{separate_strands}{Boolean If set to true, reads from forward and reverse strands are counted and stored separately. 
This option should be used if you are planning on using regression, since this doubles the number of 
predictors (F+R) and distributes predictive power more equally over prediction sets since F and R 
strand from the same chromosome cannot be both in one prediction set.}

\item{custom_name}{String The name of sample. Default samplename is the filename of the bam 
file without the .bam suffix and filepath prefix.}
}
\value{
Object NIPTSample
}
\description{
Load a BAM file and count reads in bins of size 50.000 base pairs
}
\details{
This function returns an object of class NIPTSample, the main 'currency' of this package.
It is a list with 5 items:
\itemize{
\item List \strong{autosomal_chromosome_reads} Autosomal reads are stored in
a matrix where the columns are the bins and rows (22) represent the autosomal
chromosomes. The length of this list is either 1 or 2, depending if the 
forward and reverse reads are counted separately.
\item Character \strong{correction_status_autosomal_chromosomes} The correction
status of the autosomal reads. The status can either be \emph{Uncorrected} or
\emph{GC Corrected} and/or \emph{Chi Corrected}
\item List \strong{sex_chromosome_reads} Sex chromosome reads are stored in a 
similar matrix(es) as the autosomal chromosome reads, now with 2 (X and Y) rows.
\item Character \strong{correction_status_autosomal_chromosomes} The status can 
either be \emph{Uncorrected} or \emph{GC Corrected} and/or \emph{Chi Corrected}.
\item Character \strong{sample_name} Sample name 
}
}

