% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validate-imputation.R
\name{validateImputation}
\alias{validateImputation}
\title{Validate different imputation methods' result comparing to user's input.}
\usage{
validateImputation(imputation, refer_community, clustering_args)
}
\arguments{
\item{imputation}{A list ro a matrix, the results of different imputation
method(s).}

\item{refer_community}{An igraph community object, usually got from
\code{\link{findCluster}}.}

\item{clustering_args}{A list indicating the clutering arguments used in
\code{\link{findCluster}}, usually got from \code{\link{findCluster}}.}
}
\value{
A list containing the following indicators, Jaccard similarity/ Dice
similarity coefficient/ Rand index/ Minkowski(inversed)/ Fowlkes-Mallows index
}
\description{
This function will cluster the input imputation results of no
missing data, and the clustering method will be exactly the same as the
reference clustering result (prior knowledge) based on the input. The
results of the two clusters were then analyzed to compare the effects of
imputation.
}
\examples{
# load part of the beatAML data and get the incidence matrix
beatAML_data <- NIMAA::beatAML[1:10000,]
beatAML_incidence_matrix <- el2IncMatrix(beatAML_data, print_skim = FALSE)

# do clustering
cls <- findCluster(
beatAML_incidence_matrix, # the sub-matrix
dim = 1)

# impute
imputations <- imputeMissingValue(beatAML_incidence_matrix)

# validate the imputation
validation_of_imputation <- validateImputation(
imputation = imputations,
refer_community = cls$fast_greedy,
clustering_args = cls$clustering_args
)
}
